/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer.vec;

import com.android.tools.idea.editors.gfxtrace.viewer.vec.VecD;
import java.util.Arrays;

public class MatD {
    public static final MatD IDENTITY = new MatD();
    private final double[] m;

    public MatD() {
        this(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0});
    }

    private MatD(double[] m) {
        this.m = m;
    }

    public static MatD of(double[] m) {
        return new MatD(Arrays.copyOf(m, 16));
    }

    public float[] toFloatArray() {
        return new float[]{(float)this.m[0], (float)this.m[1], (float)this.m[2], (float)this.m[3], (float)this.m[4], (float)this.m[5], (float)this.m[6], (float)this.m[7], (float)this.m[8], (float)this.m[9], (float)this.m[10], (float)this.m[11], (float)this.m[12], (float)this.m[13], (float)this.m[14], (float)this.m[15]};
    }

    public float[] toNormalMatrix(boolean invert) {
        double a = this.m[0];
        double d = this.m[1];
        double g = this.m[2];
        double b = this.m[4];
        double e = this.m[5];
        double h = this.m[6];
        double c = this.m[8];
        double f = this.m[9];
        double k = this.m[10];
        double ek = e * k;
        double fh = f * h;
        double fg = f * g;
        double dk = d * k;
        double dh = d * h;
        double eg = e * g;
        double det = (double)(invert ? -1 : 1) / (a * (ek - fh) + b * (fg - dk) + c * (dh - eg));
        return new float[]{(float)((ek - fh) * det), (float)((c * h - b * k) * det), (float)((b * f - c * e) * det), (float)((fg - dk) * det), (float)((a * k - c * g) * det), (float)((c * d - a * f) * det), (float)((dh - eg) * det), (float)((b * g - a * h) * det), (float)((a * e - b * d) * det)};
    }

    public MatD translate(double tx, double ty, double tz) {
        double[] r = (double[])this.m.clone();
        r[12] = this.m[0] * tx + this.m[4] * ty + this.m[8] * tz;
        r[13] = this.m[1] * tx + this.m[5] * ty + this.m[9] * tz;
        r[14] = this.m[2] * tx + this.m[6] * ty + this.m[10] * tz;
        return new MatD(r);
    }

    public double[] inverseOfTop3x3() {
        double a = this.m[0];
        double d = this.m[1];
        double g = this.m[2];
        double b = this.m[4];
        double e = this.m[5];
        double h = this.m[6];
        double c = this.m[8];
        double f = this.m[9];
        double k = this.m[10];
        double ek = e * k;
        double fh = f * h;
        double fg = f * g;
        double dk = d * k;
        double dh = d * h;
        double eg = e * g;
        double det = 1.0 / (a * (ek - fh) + b * (fg - dk) + c * (dh - eg));
        return new double[]{(ek - fh) * det, (fg - dk) * det, (dh - eg) * det, (c * h - b * k) * det, (a * k - c * g) * det, (b * g - a * h) * det, (b * f - c * e) * det, (c * d - a * f) * det, (a * e - b * d) * det};
    }

    public MatD multiply(MatD mat) {
        return this.multiply(mat.m);
    }

    public MatD multiply(double[] n) {
        double a00 = this.m[0];
        double a01 = this.m[1];
        double a02 = this.m[2];
        double a03 = this.m[3];
        double a10 = this.m[4];
        double a11 = this.m[5];
        double a12 = this.m[6];
        double a13 = this.m[7];
        double a20 = this.m[8];
        double a21 = this.m[9];
        double a22 = this.m[10];
        double a23 = this.m[11];
        double a30 = this.m[12];
        double a31 = this.m[13];
        double a32 = this.m[14];
        double a33 = this.m[15];
        double b00 = n[0];
        double b01 = n[1];
        double b02 = n[2];
        double b03 = n[3];
        double b10 = n[4];
        double b11 = n[5];
        double b12 = n[6];
        double b13 = n[7];
        double b20 = n[8];
        double b21 = n[9];
        double b22 = n[10];
        double b23 = n[11];
        double b30 = n[12];
        double b31 = n[13];
        double b32 = n[14];
        double b33 = n[15];
        return new MatD(new double[]{b00 * a00 + b01 * a10 + b02 * a20 + b03 * a30, b00 * a01 + b01 * a11 + b02 * a21 + b03 * a31, b00 * a02 + b01 * a12 + b02 * a22 + b03 * a32, b00 * a03 + b01 * a13 + b02 * a23 + b03 * a33, b10 * a00 + b11 * a10 + b12 * a20 + b13 * a30, b10 * a01 + b11 * a11 + b12 * a21 + b13 * a31, b10 * a02 + b11 * a12 + b12 * a22 + b13 * a32, b10 * a03 + b11 * a13 + b12 * a23 + b13 * a33, b20 * a00 + b21 * a10 + b22 * a20 + b23 * a30, b20 * a01 + b21 * a11 + b22 * a21 + b23 * a31, b20 * a02 + b21 * a12 + b22 * a22 + b23 * a32, b20 * a03 + b21 * a13 + b22 * a23 + b23 * a33, b30 * a00 + b31 * a10 + b32 * a20 + b33 * a30, b30 * a01 + b31 * a11 + b32 * a21 + b33 * a31, b30 * a02 + b31 * a12 + b32 * a22 + b33 * a32, b30 * a03 + b31 * a13 + b32 * a23 + b33 * a33});
    }

    public VecD multiply(VecD vec) {
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        return new VecD(x * this.m[0] + y * this.m[4] + z * this.m[8] + this.m[12], x * this.m[1] + y * this.m[5] + z * this.m[9] + this.m[13], x * this.m[2] + y * this.m[6] + z * this.m[10] + this.m[14]);
    }

    public void multiply(double[] vecIn, int inOffset, double[] vecOut, int outOffset) {
        double x = vecIn[inOffset + 0];
        double y = vecIn[inOffset + 1];
        double z = vecIn[inOffset + 2];
        vecOut[outOffset + 0] = x * this.m[0] + y * this.m[4] + z * this.m[8] + this.m[12];
        vecOut[outOffset + 1] = x * this.m[1] + y * this.m[5] + z * this.m[9] + this.m[13];
        vecOut[outOffset + 2] = x * this.m[2] + y * this.m[6] + z * this.m[10] + this.m[14];
    }

    public static MatD projection(double width, double height, double focalLength, double zNear) {
        double scale = 2.0 * focalLength;
        return new MatD(new double[]{scale / width, 0.0, 0.0, 0.0, 0.0, scale / height, 0.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0, -2.0 * zNear, 0.0});
    }

    public static MatD lookAt(VecD eye, VecD center, VecD up) {
        VecD forward = center.subtract(eye).normalize();
        VecD side = forward.cross(up).normalize();
        VecD newUp = side.cross(forward).normalize();
        return new MatD(new double[]{side.x, newUp.x, -forward.x, 0.0, side.y, newUp.y, -forward.y, 0.0, side.z, newUp.z, -forward.z, 0.0, -eye.x * side.x - eye.y * side.y - eye.z * side.z, -eye.x * newUp.x - eye.y * newUp.y - eye.z * newUp.z, eye.x * forward.x + eye.y * forward.y + eye.z * forward.z, 1.0});
    }

    public static MatD translation(double tx, double ty, double tz) {
        return new MatD(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, tx, ty, tz, 1.0});
    }

    public static MatD makeTranslationRotXY(double tx, double ty, double tz, double angleX, double angleY) {
        double cosX = Math.cos(Math.toRadians(angleX));
        double sinX = Math.sin(Math.toRadians(angleX));
        double cosY = Math.cos(Math.toRadians(angleY));
        double sinY = Math.sin(Math.toRadians(angleY));
        return new MatD(new double[]{cosY, sinX * sinY, -cosX * sinY, 0.0, 0.0, cosX, sinX, 0.0, sinY, -sinX * cosY, cosX * cosY, 0.0, tx, ty, tz, 1.0});
    }

    public static MatD makeScaleTranslation(double scale, VecD t) {
        return new MatD(new double[]{scale, 0.0, 0.0, 0.0, 0.0, scale, 0.0, 0.0, 0.0, 0.0, scale, 0.0, scale * t.x, scale * t.y, scale * t.z, 1.0});
    }

    public static MatD makeScaleTranslationZupToYup(double scale, VecD t) {
        return new MatD(new double[]{scale, 0.0, 0.0, 0.0, 0.0, 0.0, -scale, 0.0, 0.0, scale, 0.0, 0.0, scale * t.x, scale * t.z, -scale * t.y, 1.0});
    }
}

