/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer.geo;

import com.android.tools.idea.editors.gfxtrace.viewer.vec.MatD;
import com.android.tools.idea.editors.gfxtrace.viewer.vec.VecD;

public class BoundingBox {
    public static final BoundingBox INVALID = new BoundingBox();
    public final double[] min = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
    public final double[] max = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};

    public void add(VecD vec) {
        this.add(vec.x, vec.y, vec.z);
    }

    public void add(double x, double y, double z) {
        VecD.min(this.min, x, y, z);
        VecD.max(this.max, x, y, z);
    }

    public MatD getCenteringMatrix(double diagonalSize, boolean zUp) {
        VecD min = VecD.fromArray(this.min);
        VecD max = VecD.fromArray(this.max);
        double diagonal = max.distance(min);
        VecD translation = max.subtract(min).scale(0.5).add(min).scale(-1.0);
        double scale = diagonal == 0.0 ? 1.0 : diagonalSize / diagonal;
        return zUp ? MatD.makeScaleTranslationZupToYup(scale, translation) : MatD.makeScaleTranslation(scale, translation);
    }

    public BoundingBox transform(MatD transform) {
        VecD tMin = transform.multiply(VecD.fromArray(this.min));
        VecD tMax = transform.multiply(VecD.fromArray(this.max));
        BoundingBox result = new BoundingBox();
        result.add(tMin);
        result.add(tMax);
        return result;
    }
}

