/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer;

import com.android.tools.idea.editors.gfxtrace.service.gfxapi.GfxAPIProtos;
import com.android.tools.idea.editors.gfxtrace.viewer.Renderable;
import com.android.tools.idea.editors.gfxtrace.viewer.camera.Emitter;
import com.android.tools.idea.editors.gfxtrace.viewer.geo.BoundingBox;
import com.android.tools.idea.editors.gfxtrace.viewer.geo.Model;
import com.android.tools.idea.editors.gfxtrace.viewer.gl.Buffer;
import com.android.tools.idea.editors.gfxtrace.viewer.vec.MatD;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;

public class Geometry {
    private Model myModel;
    private MatD myModelMatrix;
    private boolean myZUp;

    public Geometry() {
        this.setZUp(false);
    }

    public void setModel(Model model) {
        this.myModel = model;
        this.updateModelMatrix();
    }

    public Model getModel() {
        return this.myModel;
    }

    public void setZUp(boolean zUp) {
        this.myZUp = zUp;
        this.updateModelMatrix();
    }

    public BoundingBox getBounds() {
        if (this.myModel != null) {
            return this.myModel.getBounds();
        }
        return BoundingBox.INVALID;
    }

    private void updateModelMatrix() {
        this.myModelMatrix = this.getBounds().getCenteringMatrix(2.1, this.myZUp);
    }

    public Renderable asRenderable(DisplayMode displayMode) {
        if (this.myModel == null) {
            return Renderable.NOOP;
        }
        final int polygonMode = displayMode.glPolygonMode;
        final int modelPrimitive = this.translatePrimitive(this.myModel.getPrimitive());
        final float[] positions = this.myModel.getPositions();
        final float[] normals = this.myModel.getNormals();
        final int[] indices = this.myModel.getIndices();
        return new Renderable(){
            private Buffer positionBuffer;
            private Buffer normalBuffer;
            private Buffer indexBuffer;

            @Override
            public void init(GL2ES2 gl) {
                this.positionBuffer = new Buffer((GL)gl, 34962).bind().loadData(Buffer.wrap(positions));
                if (normals != null) {
                    this.normalBuffer = new Buffer((GL)gl, 34962).bind().loadData(Buffer.wrap(normals));
                }
                this.indexBuffer = new Buffer((GL)gl, 34963).bind().loadData(Buffer.wrap(indices));
            }

            @Override
            public void render(GL2ES2 gl, Renderable.State state) {
                state.transform.push(Geometry.this.myModelMatrix);
                state.transform.apply(state.shader);
                gl.getGL2GL3().glPolygonMode(1032, polygonMode);
                this.positionBuffer.bind();
                state.shader.bindAttribute("aVertexPosition", 3, 5126, 12, 0);
                if (this.normalBuffer != null) {
                    this.normalBuffer.bind();
                    state.shader.bindAttribute("aVertexNormal", 3, 5126, 12, 0);
                } else {
                    state.shader.setAttribute("aVertexNormal", 1.0f, 0.0f, 0.0f);
                }
                this.indexBuffer.bind();
                gl.glDrawElements(modelPrimitive, indices.length, 5125, 0L);
                state.shader.unbindAttribute("aVertexPosition");
                if (this.normalBuffer != null) {
                    state.shader.unbindAttribute("aVertexNormal");
                }
                gl.getGL2GL3().glPolygonMode(1032, 6914);
                state.transform.pop();
            }

            @Override
            public void dispose(GL2ES2 gl) {
                if (this.positionBuffer != null) {
                    this.positionBuffer.delete();
                    this.positionBuffer = null;
                }
                if (this.normalBuffer != null) {
                    this.normalBuffer.delete();
                    this.normalBuffer = null;
                }
                if (this.indexBuffer != null) {
                    this.indexBuffer.delete();
                    this.indexBuffer = null;
                }
            }
        };
    }

    public Emitter getEmitter() {
        return Emitter.BoxEmitter.fromBoundingBox(this.getBounds().transform(this.myModelMatrix));
    }

    private int translatePrimitive(GfxAPIProtos.DrawPrimitive primitive) {
        switch (primitive.getNumber()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        throw new AssertionError();
    }

    public static enum DisplayMode {
        POINTS(6912),
        LINES(6913),
        TRIANGLES(6914);

        public final int glPolygonMode;

        private DisplayMode(int glPolygonMode) {
            this.glPolygonMode = glPolygonMode;
        }
    }
}

