/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.path;

import com.android.tools.idea.editors.gfxtrace.service.path.AsPath;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import org.jetbrains.annotations.NotNull;

public abstract class Path
implements BinaryObject {
    public static final Path EMPTY = new Path(){

        @Override
        public Path getParent() {
            return null;
        }

        @Override
        public String getSegmentString() {
            return "EMPTY";
        }

        @NotNull
        public BinaryClass klass() {
            throw new UnsupportedOperationException();
        }
    };
    private String myString;

    public abstract Path getParent();

    public String toString() {
        if (this.myString == null) {
            this.myString = this.stringPath(new StringBuilder()).toString();
        }
        return this.myString;
    }

    private StringBuilder stringPath(StringBuilder stringBuilder) {
        Path parent = this.getParent();
        if (parent != null) {
            parent.stringPath(stringBuilder);
            this.appendSegmentToPath(stringBuilder);
        } else {
            stringBuilder.append(this.getSegmentString());
        }
        return stringBuilder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.toString().equals(((Path)o).toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public abstract String getSegmentString();

    public void appendSegmentToPath(StringBuilder builder) {
        builder.append(".");
        builder.append(this.getSegmentString());
    }

    @NotNull
    public static Path wrap(BinaryObject object) {
        return (Path)object;
    }

    @NotNull
    public BinaryObject unwrap() {
        return this;
    }

    public AsPath as(Object type) {
        AsPath p = new AsPath();
        p.setObject(this);
        p.setType(type);
        return p;
    }
}

