/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.image;

import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.gfxapi.Cubemap;
import com.android.tools.idea.editors.gfxtrace.service.gfxapi.CubemapLevel;
import com.android.tools.idea.editors.gfxtrace.service.gfxapi.Texture2D;
import com.android.tools.idea.editors.gfxtrace.service.image.FmtRGBA;
import com.android.tools.idea.editors.gfxtrace.service.image.Format;
import com.android.tools.idea.editors.gfxtrace.service.image.ImageInfo;
import com.android.tools.idea.editors.gfxtrace.service.image.MultiLevelImage;
import com.android.tools.idea.editors.gfxtrace.service.path.ImageInfoPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FetchedImage
implements MultiLevelImage {
    @NotNull
    private final Level[] myLevels;

    public static ListenableFuture<FetchedImage> load(final ServiceClient client, ListenableFuture<ImageInfoPath> imageInfo) {
        return Futures.transform(imageInfo, (AsyncFunction)new AsyncFunction<ImageInfoPath, FetchedImage>(){

            public ListenableFuture<FetchedImage> apply(ImageInfoPath imageInfoPath) throws Exception {
                return FetchedImage.load(client, imageInfoPath);
            }
        });
    }

    public static ListenableFuture<FetchedImage> load(final ServiceClient client, Path imagePath) {
        return Futures.transform(client.get(imagePath.as(Format.RGBA)), (Function)new Function<Object, FetchedImage>(){

            public FetchedImage apply(Object object) {
                if (object instanceof ImageInfo) {
                    return new FetchedImage(client, (ImageInfo)object);
                }
                if (object instanceof Texture2D) {
                    return new FetchedImage(client, (Texture2D)object);
                }
                if (object instanceof Cubemap) {
                    return new FetchedImage(client, (Cubemap)object);
                }
                throw new UnsupportedOperationException("Unexpected resource type " + object.toString());
            }
        });
    }

    public FetchedImage(ServiceClient client, ImageInfo imageInfo) {
        this.myLevels = new Level[]{new SingleFacedLevel(client, imageInfo)};
    }

    public FetchedImage(ServiceClient client, Texture2D texture) {
        ImageInfo[] infos = texture.getLevels();
        this.myLevels = new Level[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            this.myLevels[i] = new SingleFacedLevel(client, infos[i]);
        }
    }

    public FetchedImage(ServiceClient client, Cubemap cubemap) {
        CubemapLevel[] infos = cubemap.getLevels();
        this.myLevels = new Level[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            this.myLevels[i] = new SixFacedLevel(client, infos[i]);
        }
    }

    @Override
    public int getLevelCount() {
        return this.myLevels.length;
    }

    @Override
    public ListenableFuture<BufferedImage> getLevel(int index) {
        return index < 0 || index >= this.myLevels.length ? Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("Invalid image level")) : this.myLevels[index].get();
    }

    public static ListenableFuture<BufferedImage> loadLevel(ListenableFuture<FetchedImage> futureImage, final int level) {
        return Futures.transform(futureImage, (AsyncFunction)new AsyncFunction<FetchedImage, BufferedImage>(){

            public ListenableFuture<BufferedImage> apply(FetchedImage image) throws Exception {
                return image.getLevel(Math.min(level, image.getLevelCount()));
            }
        });
    }

    private static class SixFacedLevel
    extends Level {
        private final ServiceClient client;
        private final ImageInfo[] imageInfos;

        public SixFacedLevel(ServiceClient client, CubemapLevel level) {
            this.client = client;
            this.imageInfos = new ImageInfo[]{level.getNegativeX(), level.getPositiveX(), level.getNegativeY(), level.getPositiveY(), level.getNegativeZ(), level.getPositiveZ()};
        }

        @Override
        protected ListenableFuture<BufferedImage> doLoad() {
            ListenableFuture[] futures = new ListenableFuture[this.imageInfos.length];
            for (int i = 0; i < this.imageInfos.length; ++i) {
                futures[i] = this.client.get(this.imageInfos[i].getData());
            }
            return Futures.transform((ListenableFuture)Futures.allAsList((ListenableFuture[])futures), (Function)new Function<List<byte[]>, BufferedImage>(){

                public BufferedImage apply(List<byte[]> data) {
                    return Level.convertImage(imageInfos, (byte[][])data.toArray((T[])new byte[data.size()][]));
                }
            });
        }
    }

    private static class SingleFacedLevel
    extends Level {
        private final ServiceClient client;
        private final ImageInfo imageInfo;

        public SingleFacedLevel(ServiceClient client, ImageInfo imageInfo) {
            this.client = client;
            this.imageInfo = imageInfo;
        }

        @Override
        protected ListenableFuture<BufferedImage> doLoad() {
            return Futures.transform(this.client.get(this.imageInfo.getData()), (Function)new Function<byte[], BufferedImage>(){

                public BufferedImage apply(byte[] data) {
                    return Level.convertImage(imageInfo, data);
                }
            });
        }
    }

    private static abstract class Level
    implements Function<BufferedImage, BufferedImage> {
        public static final Level EMPTY = new Level(){

            @Override
            public ListenableFuture<BufferedImage> get() {
                return Futures.immediateFuture((Object)MultiLevelImage.EMPTY_LEVEL);
            }

            @Override
            protected ListenableFuture<BufferedImage> doLoad() {
                return null;
            }
        };
        private BufferedImage image;

        private Level() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListenableFuture<BufferedImage> get() {
            BufferedImage result;
            Level level = this;
            synchronized (level) {
                result = this.image;
            }
            return result == null ? Futures.transform(this.doLoad(), (Function)this) : Futures.immediateFuture((Object)this.image);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage apply(BufferedImage input) {
            Level level = this;
            synchronized (level) {
                this.image = input;
            }
            return input;
        }

        protected abstract ListenableFuture<BufferedImage> doLoad();

        protected static BufferedImage convertImage(@NotNull ImageInfo imageInfo, @NotNull byte[] data) {
            assert (imageInfo.getFormat() instanceof FmtRGBA);
            BufferedImage image = new BufferedImage(imageInfo.getWidth(), imageInfo.getHeight(), 6);
            Level.updateImageData(image, data, 0, 0, imageInfo.getWidth(), imageInfo.getHeight());
            return image;
        }

        protected static BufferedImage convertImage(@NotNull ImageInfo[] imageInfos, @NotNull byte[][] data) {
            assert (imageInfos.length == data.length && imageInfos.length == 6);
            int width = Math.max(Math.max(Math.max(Math.max(Math.max(imageInfos[0].getWidth(), imageInfos[1].getWidth()), imageInfos[2].getWidth()), imageInfos[3].getWidth()), imageInfos[4].getWidth()), imageInfos[5].getWidth());
            int height = Math.max(Math.max(Math.max(Math.max(Math.max(imageInfos[0].getHeight(), imageInfos[1].getHeight()), imageInfos[2].getHeight()), imageInfos[3].getHeight()), imageInfos[4].getHeight()), imageInfos[5].getHeight());
            BufferedImage image = new BufferedImage(4 * width, 3 * height, 6);
            Level.updateImageData(image, data[0], 0 * width, 1 * height, imageInfos[0].getWidth(), imageInfos[0].getHeight());
            Level.updateImageData(image, data[1], 2 * width, 1 * height, imageInfos[1].getWidth(), imageInfos[1].getHeight());
            Level.updateImageData(image, data[2], 1 * width, 0 * height, imageInfos[2].getWidth(), imageInfos[2].getHeight());
            Level.updateImageData(image, data[3], 1 * width, 2 * height, imageInfos[3].getWidth(), imageInfos[3].getHeight());
            Level.updateImageData(image, data[4], 3 * width, 1 * height, imageInfos[4].getWidth(), imageInfos[4].getHeight());
            Level.updateImageData(image, data[5], 1 * width, 1 * height, imageInfos[5].getWidth(), imageInfos[5].getHeight());
            return image;
        }

        private static void updateImageData(BufferedImage image, byte[] data, int x, int y, int w, int h) {
            assert (x + w <= image.getWidth() && y + h <= image.getHeight());
            byte[] destination = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            int imageWidth = image.getWidth();
            int row = 0;
            int from = 0;
            int to = ((y + h - 1) * imageWidth + x) * 4;
            while (row < h) {
                int col = 0;
                int i = to;
                int j = from;
                while (col < w) {
                    destination[i + 0] = data[j + 3];
                    destination[i + 1] = data[j + 2];
                    destination[i + 2] = data[j + 1];
                    destination[i + 3] = data[j + 0];
                    ++col;
                    i += 4;
                    j += 4;
                }
                ++row;
                from += w * 4;
                to -= imageWidth * 4;
            }
        }
    }
}

