/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.atom;

import com.android.tools.idea.editors.gfxtrace.service.atom.Atom;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomMetadata;
import com.android.tools.idea.editors.gfxtrace.service.atom.Observations;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Field;
import org.jetbrains.annotations.NotNull;

public class DynamicAtom
extends Atom {
    @NotNull
    private final Dynamic myValue;
    @NotNull
    private final AtomMetadata myMetadata;

    public DynamicAtom(Dynamic value) {
        this.myValue = value;
        this.myMetadata = AtomMetadata.find(value.type());
    }

    @Override
    @NotNull
    public BinaryObject unwrap() {
        return this.myValue;
    }

    @Override
    public String getName() {
        return this.myMetadata.getDisplayName();
    }

    @Override
    public int getFieldCount() {
        return this.myValue.getFieldCount();
    }

    @Override
    public Field getFieldInfo(int index) {
        return this.myValue.getFieldInfo(index);
    }

    @Override
    public Object getFieldValue(int index) {
        return this.myValue.getFieldValue(index);
    }

    @Override
    public int getExtrasIndex() {
        return this.myMetadata.myExtrasIndex;
    }

    @Override
    public Observations getObservations() {
        if (this.myMetadata.myExtrasIndex >= 0) {
            Object extras = this.getFieldValue(this.myMetadata.myExtrasIndex);
            assert (extras instanceof Object[]);
            for (Object extra : (Object[])extras) {
                if (!(extra instanceof Observations)) continue;
                return (Observations)extra;
            }
        }
        return null;
    }

    @Override
    public int getResultIndex() {
        return this.myMetadata.myResultIndex;
    }

    @Override
    public boolean isEndOfFrame() {
        return this.myMetadata.getEndOfFrame();
    }

    @Override
    public boolean isDrawCall() {
        return this.myMetadata.getDrawCall();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicAtom that = (DynamicAtom)o;
        if (!this.myValue.equals((Object)that.myValue)) {
            return false;
        }
        return this.myMetadata.equals(that.myMetadata);
    }

    public int hashCode() {
        int result = this.myValue.hashCode();
        result = 31 * result + this.myMetadata.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append('(');
        boolean needComma = false;
        int c = this.getFieldCount();
        for (int i = 0; i < c; ++i) {
            if (!this.isParameter(i)) continue;
            if (needComma) {
                sb.append(", ");
            }
            needComma = true;
            sb.append(this.getFieldInfo(i).getName());
            sb.append(": ");
            sb.append(this.getFieldValue(i));
        }
        sb.append(')');
        return sb.toString();
    }
}

