/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.atom;

import com.android.tools.idea.editors.gfxtrace.controllers.AtomController;
import com.android.tools.idea.editors.gfxtrace.service.atom.DynamicAtom;
import com.android.tools.idea.editors.gfxtrace.service.atom.Observation;
import com.android.tools.idea.editors.gfxtrace.service.atom.Observations;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Field;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class Atom {
    public static Atom wrap(BinaryObject object) {
        if (object instanceof Dynamic) {
            return new DynamicAtom((Dynamic)object);
        }
        return (Atom)object;
    }

    public void buildTree(@NotNull DefaultMutableTreeNode parent, long index) {
        DefaultMutableTreeNode atomNode = new DefaultMutableTreeNode(new AtomController.Node(index, this), true);
        parent.add(atomNode);
        Observations observations = this.getObservations();
        if (observations != null) {
            for (Observation read : observations.getReads()) {
                atomNode.add(new DefaultMutableTreeNode(new AtomController.Memory(index, read, true), false));
            }
            for (Observation write : observations.getWrites()) {
                atomNode.add(new DefaultMutableTreeNode(new AtomController.Memory(index, write, false), false));
            }
        }
    }

    @NotNull
    public abstract BinaryObject unwrap();

    public abstract String getName();

    public abstract int getFieldCount();

    public abstract Field getFieldInfo(int var1);

    public abstract Object getFieldValue(int var1);

    public abstract int getExtrasIndex();

    public abstract Observations getObservations();

    public abstract int getResultIndex();

    public abstract boolean isEndOfFrame();

    public abstract boolean isDrawCall();

    public final boolean isParameter(int fieldIndex) {
        return fieldIndex != this.getExtrasIndex() && fieldIndex != this.getResultIndex();
    }
}

