/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.renderers;

import com.android.tools.idea.editors.gfxtrace.controllers.AtomController;
import com.android.tools.idea.editors.gfxtrace.controllers.StateController;
import com.android.tools.idea.editors.gfxtrace.renderers.RenderUtils;
import com.android.tools.idea.editors.gfxtrace.service.atom.Atom;
import com.android.tools.idea.editors.gfxtrace.service.atom.DynamicAtom;
import com.android.tools.idea.editors.gfxtrace.service.memory.MemoryPointer;
import com.android.tools.idea.editors.gfxtrace.service.memory.MemoryRange;
import com.android.tools.idea.editors.gfxtrace.service.memory.MemorySliceInfo;
import com.android.tools.idea.editors.gfxtrace.service.memory.MemorySliceMetadata;
import com.android.tools.idea.editors.gfxtrace.service.snippets.CanFollow;
import com.android.tools.idea.editors.gfxtrace.service.snippets.Labels;
import com.android.tools.idea.editors.gfxtrace.service.snippets.SnippetObject;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.schema.AnyType;
import com.android.tools.rpclib.schema.Array;
import com.android.tools.rpclib.schema.Constant;
import com.android.tools.rpclib.schema.ConstantSet;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Interface;
import com.android.tools.rpclib.schema.Map;
import com.android.tools.rpclib.schema.Pointer;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Slice;
import com.android.tools.rpclib.schema.Struct;
import com.android.tools.rpclib.schema.Type;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Render {
    public static final int NO_TAG = -1;
    public static final int STATE_VALUE_TAG = 0;
    @NotNull
    private static final Logger LOG = Logger.getInstance(Render.class);
    private static final int MAX_DISPLAY = 3;

    private static void render(@Nullable Object value, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        if (value instanceof SnippetObject) {
            Render.render((SnippetObject)value, component, attributes, tag);
            return;
        }
        if (value instanceof DynamicAtom) {
            Render.render((DynamicAtom)value, component, attributes, tag);
            return;
        }
        if (value instanceof MemoryPointer) {
            Render.render((MemoryPointer)value, component, attributes, tag);
            return;
        }
        if (value instanceof MemoryRange) {
            Render.render((MemoryRange)value, component, attributes, tag);
            return;
        }
        component.append(String.valueOf(value), attributes, (Object)tag);
    }

    public static void render(@NotNull SnippetObject obj, @NotNull Dynamic dynamic, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        MemoryPointer mp = Render.tryMemoryPointer(dynamic);
        if (mp != null) {
            Render.render(mp, component, attributes, tag);
            return;
        }
        if (dynamic.getFieldCount() == 1 && dynamic.getFieldValue(0) instanceof MemorySliceInfo) {
            Render.render((MemorySliceInfo)dynamic.getFieldValue(0), Render.getSliceMetadata(dynamic), component, attributes, tag);
            return;
        }
        component.append("{", SimpleTextAttributes.GRAY_ATTRIBUTES, (Object)-1);
        for (int index = 0; index < dynamic.getFieldCount(); ++index) {
            if (index > 0) {
                component.append(", ", SimpleTextAttributes.GRAY_ATTRIBUTES, (Object)-1);
            }
            Field field = dynamic.getFieldInfo(index);
            component.append(field.getName() + ":", SimpleTextAttributes.GRAY_ATTRIBUTES, (Object)index);
            SnippetObject paramValue = obj.field(dynamic, index);
            SimpleTextAttributes attr = Render.paramAttributes(-1, index, paramValue, attributes);
            Render.render(paramValue, field.getType(), component, attr, index);
        }
        component.append("}", SimpleTextAttributes.GRAY_ATTRIBUTES, (Object)-1);
    }

    @Nullable
    private static MemorySliceMetadata getSliceMetadata(@NotNull Dynamic dynamic) {
        BinaryObject[] metaData;
        for (BinaryObject md : metaData = dynamic.type().getMetadata()) {
            if (!(md instanceof MemorySliceMetadata)) continue;
            return (MemorySliceMetadata)md;
        }
        return null;
    }

    private static MemoryPointer tryMemoryPointer(Dynamic dynamic) {
        Entity entity = dynamic.klass().entity();
        Field[] fields = entity.getFields();
        MemoryPointer mp = new MemoryPointer();
        Field[] mpFields = mp.klass().entity().getFields();
        if (mpFields.length != fields.length) {
            return null;
        }
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].equals((Object)mpFields[i])) continue;
            return null;
        }
        long address = (Long)dynamic.getFieldValue(0);
        int poolId = ((Number)dynamic.getFieldValue(1)).intValue();
        mp.setAddress(address);
        mp.setPool(poolId);
        return mp;
    }

    public static void render(@NotNull StateController.Node node, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, boolean expanded) {
        if (node.key.type != null) {
            Render.render(node.key.value, node.key.type, component, attributes, -1);
        } else {
            component.append(String.valueOf(node.key.value.getObject()), attributes);
        }
        if ((node.isLeaf() || !expanded && node.canBeRenderedAsLeaf()) && node.value != null && node.value.value != null) {
            component.append(": ", attributes);
            if (node.value.value.getObject() != null) {
                SimpleTextAttributes style = node.canFollow() ? SimpleTextAttributes.LINK_ATTRIBUTES : SimpleTextAttributes.SYNTHETIC_ATTRIBUTES;
                Render.render(node.value.value, node.value.type, component, style, 0);
            } else {
                component.append("null");
            }
        }
    }

    public static void render(@NotNull AtomController.Node node, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        Render.render(node.index, component, attributes, -1);
        if (node.atom != null) {
            component.append(": ", attributes);
            Render.render(node.atom, component, node.hoveredParameter);
        }
    }

    public static void render(@NotNull AtomController.Memory memory, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        Render.render(memory.isRead ? "read:" : "write:", component, attributes, -1);
        Render.render(memory.observation.getRange(), component, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES, -1);
    }

    public static void render(@NotNull AtomController.Group group, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        Render.render(group.group.getRange().getStart(), component, attributes, -1);
        component.append(": ", attributes);
        component.append(group.group.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        long count = group.group.getRange().getCount();
        String range = "  (" + count + " Command" + (count != 1L ? "s" : "") + ")";
        component.append(range, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    public static void render(@NotNull Atom atom, @NotNull SimpleColoredComponent component, int hoveredParameter) {
        if (atom instanceof DynamicAtom) {
            Render.render((DynamicAtom)atom, component, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES, hoveredParameter);
        } else {
            Render.render(atom, component, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES, -1);
        }
    }

    public static void render(@NotNull DynamicAtom atom, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int highlightedParameter) {
        component.append(atom.getName() + "(", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, (Object)-1);
        int resultIndex = atom.getResultIndex();
        int extrasIndex = atom.getExtrasIndex();
        boolean needComma = false;
        for (int i = 0; i < atom.getFieldCount(); ++i) {
            if (i == resultIndex || i == extrasIndex) continue;
            Field field = atom.getFieldInfo(i);
            if (needComma) {
                component.append(", ", SimpleTextAttributes.REGULAR_ATTRIBUTES, (Object)-1);
            }
            needComma = true;
            SnippetObject paramValue = SnippetObject.param(atom, i);
            SimpleTextAttributes attr = Render.paramAttributes(highlightedParameter, i, paramValue, attributes);
            component.append(field.getDeclared() + ":", attr, (Object)i);
            Render.render(paramValue, field.getType(), component, attr, i);
        }
        component.append(")", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, (Object)-1);
        if (resultIndex >= 0) {
            SnippetObject paramValue = SnippetObject.param(atom, resultIndex);
            SimpleTextAttributes attr = Render.paramAttributes(highlightedParameter, resultIndex, paramValue, attributes);
            component.append("->", attr, (Object)resultIndex);
            Field field = atom.getFieldInfo(resultIndex);
            Render.render(paramValue, field.getType(), component, attr, -1);
        }
    }

    private static boolean isHighlighted(int highlightedParameter, int i, @NotNull SnippetObject paramValue) {
        return i == highlightedParameter || CanFollow.fromSnippets(paramValue.getSnippets()) != null;
    }

    private static SimpleTextAttributes paramAttributes(int highlightedParameter, int i, SnippetObject paramValue, SimpleTextAttributes attributes) {
        return Render.isHighlighted(highlightedParameter, i, paramValue) ? SimpleTextAttributes.LINK_ATTRIBUTES : attributes;
    }

    public static void render(@NotNull MemoryPointer pointer, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        if (0 != pointer.getPool()) {
            if (pointer.getAddress() != 0L) {
                component.append(Render.toPointerString(pointer.getAddress()) + " ", attributes, (Object)tag);
            }
            component.append("Pool: ", attributes, (Object)tag);
            component.append("0x" + Long.toHexString(pointer.getPool()), attributes, (Object)tag);
        } else {
            component.append(Render.toPointerString(pointer.getAddress()), attributes, (Object)tag);
        }
    }

    static String toPointerString(long pointer) {
        String hex = Long.toHexString(pointer);
        if (hex.length() > 8) {
            return "0x" + StringUtil.repeat((String)"0", (int)(16 - hex.length())) + hex;
        }
        return "0x" + StringUtil.repeat((String)"0", (int)(8 - hex.length())) + hex;
    }

    public static void render(@NotNull MemoryRange range, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        component.append(Long.toString(range.getSize()), attributes, (Object)tag);
        component.append(" bytes at ", SimpleTextAttributes.GRAY_ATTRIBUTES, (Object)tag);
        component.append("0x" + Long.toHexString(range.getBase()), attributes, (Object)tag);
    }

    public static void render(@NotNull MemorySliceInfo info, @Nullable MemorySliceMetadata metaData, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        if (metaData != null) {
            component.append(metaData.getElementTypeName(), attributes, (Object)tag);
        }
        component.append("[" + info.getCount() + "]", attributes, (Object)tag);
        if (info.getPool() != 0 || info.getBase() != 0L) {
            component.append(" (", attributes, (Object)tag);
            MemoryPointer pointer = new MemoryPointer();
            pointer.setAddress(info.getBase());
            pointer.setPool(info.getPool());
            Render.render(pointer, component, attributes, tag);
            component.append(")", attributes, (Object)tag);
        }
    }

    public static void render(@NotNull SnippetObject value, @NotNull Type type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        if (type instanceof Primitive) {
            Render.render(value, (Primitive)type, component, attributes, tag);
            return;
        }
        if (type instanceof Struct) {
            Render.render(value, (Struct)type, component, attributes, tag);
            return;
        }
        if (type instanceof Pointer) {
            Render.render(value, (Pointer)type, component, attributes, tag);
            return;
        }
        if (type instanceof Interface) {
            Render.render(value, (Interface)type, component, attributes, tag);
            return;
        }
        if (type instanceof Array) {
            Render.render(value, (Array)type, component, attributes);
            return;
        }
        if (type instanceof Slice) {
            Render.render(value, (Slice)type, component, attributes);
            return;
        }
        if (type instanceof Map) {
            Render.render(value, (Map)type, component, attributes);
            return;
        }
        if (type instanceof AnyType) {
            Render.render(value, (AnyType)type, component, attributes, tag);
            return;
        }
        Render.render(value, component, attributes, tag);
    }

    public static void render(@NotNull SnippetObject value, @NotNull Struct type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        Render.render(value, component, attributes, tag);
    }

    public static void render(@NotNull SnippetObject value, @NotNull Pointer type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        component.append("*", SimpleTextAttributes.GRAY_ATTRIBUTES);
        Render.render(value, component, attributes, tag);
    }

    public static void render(@NotNull SnippetObject value, @NotNull Interface type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        component.append("$", SimpleTextAttributes.GRAY_ATTRIBUTES);
        Render.render(value, component, attributes, tag);
    }

    public static void render(@NotNull SnippetObject obj, @NotNull Array type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        Object value = obj.getObject();
        assert (value instanceof Object[]);
        Render.render(obj, (Object[])value, type.getValueType(), component, attributes);
    }

    public static void render(@NotNull SnippetObject obj, @NotNull Slice type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        Object value = obj.getObject();
        if (value instanceof Object[]) {
            Render.render(obj, (Object[])value, type.getValueType(), component, attributes);
        } else if (value instanceof byte[]) {
            Render.render(obj, (byte[])value, type.getValueType(), component, attributes);
        } else assert (false);
    }

    public static void render(@NotNull SnippetObject value, @NotNull Map type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        java.util.Map map = (java.util.Map)value.getObject();
        Iterator it = map.entrySet().iterator();
        component.append("{", SimpleTextAttributes.GRAY_ATTRIBUTES, (Object)-1);
        int index = 0;
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            Render.render(value.key(entry), type.getKeyType(), component, attributes, index);
            component.append("=", SimpleTextAttributes.GRAY_ATTRIBUTES, (Object)index);
            SnippetObject paramValue = value.elem(entry);
            SimpleTextAttributes attr = Render.paramAttributes(-1, index, paramValue, attributes);
            Render.render(paramValue, type.getValueType(), component, attr, index);
            if (it.hasNext()) {
                component.append(", ", SimpleTextAttributes.GRAY_ATTRIBUTES, (Object)-1);
            }
            ++index;
        }
        component.append("}", SimpleTextAttributes.GRAY_ATTRIBUTES, (Object)-1);
    }

    public static void render(@NotNull SnippetObject value, @NotNull AnyType type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        Render.render(value, component, attributes, tag);
    }

    private static Constant pickShortestName(@NotNull Collection<Constant> constants) {
        int len = Integer.MAX_VALUE;
        Constant shortest = null;
        for (Constant constant : constants) {
            int l = constant.getName().length();
            if (l >= len) continue;
            len = l;
            shortest = constant;
        }
        return shortest;
    }

    public static boolean tryConstantRender(@NotNull SnippetObject obj, @NotNull Primitive type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        Collection<Constant> value = Render.findConstant(obj, type);
        if (!value.isEmpty()) {
            component.append(value.stream().map(Constant::getName).collect(Collectors.joining(" | ")), attributes, (Object)tag);
            return true;
        }
        return false;
    }

    @NotNull
    public static Collection<Constant> findConstant(@NotNull SnippetObject obj, @NotNull Primitive type) {
        long valueNumber;
        ConstantSet constants = ConstantSet.lookup((Type)type);
        if (constants == null || constants.getEntries().length == 0) {
            return Collections.emptyList();
        }
        List byValue = constants.getByValue(obj.getObject());
        if (byValue != null && byValue.size() != 0) {
            if (byValue.size() == 1) {
                return byValue;
            }
            Labels labels = Labels.fromSnippets(obj.getSnippets());
            Constant result = Render.disambiguate(byValue, labels);
            return result == null ? Collections.emptyList() : ImmutableList.of((Object)result);
        }
        Object value = obj.getObject();
        if (!(value instanceof Number) || value instanceof Double || value instanceof Float) {
            return Collections.emptyList();
        }
        long leftToFind = valueNumber = ((Number)value).longValue();
        ArrayListMultimap resultMap = ArrayListMultimap.create();
        for (Constant constant : constants.getEntries()) {
            long constantValue = ((Number)constant.getValue()).longValue();
            if (Long.bitCount(constantValue) != 1 || (valueNumber & constantValue) == 0L) continue;
            resultMap.put((Object)constantValue, (Object)constant);
            leftToFind &= constantValue ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (leftToFind != 0L) {
            return Collections.emptyList();
        }
        if (resultMap.keySet().size() == resultMap.size()) {
            return resultMap.values();
        }
        Labels labels = Labels.fromSnippets(obj.getSnippets());
        for (Number key : resultMap.keySet()) {
            Collection flagConstants = resultMap.get((Object)key);
            if (flagConstants.size() == 1) continue;
            Constant con = Render.disambiguate(flagConstants, labels);
            if (con != null) {
                resultMap.replaceValues((Object)key, (Iterable)ImmutableList.of((Object)con));
                continue;
            }
            return Collections.emptyList();
        }
        assert (resultMap.keySet().size() == resultMap.size());
        return resultMap.values();
    }

    @Nullable(value="can not disambiguate")
    private static Constant disambiguate(@NotNull Collection<Constant> constants, @Nullable Labels labels) {
        Collection<Constant> preferred;
        if (labels != null) {
            preferred = labels.preferred(constants);
            if (preferred.size() == 1) {
                return (Constant)Iterators.get(preferred.iterator(), (int)0);
            }
            if (preferred.size() == 0) {
                preferred = constants;
            }
        } else {
            preferred = constants;
        }
        if (preferred.size() < 8) {
            return Render.pickShortestName(preferred);
        }
        return null;
    }

    public static void render(@NotNull SnippetObject obj, @NotNull Primitive type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        if (Render.tryConstantRender(obj, type, component, attributes, tag)) {
            return;
        }
        Object value = obj.getObject();
        switch (type.getMethod().getValue()) {
            case 0: {
                component.append(String.format("%b", (Boolean)value), attributes, (Object)tag);
                return;
            }
            case 11: {
                component.append(String.valueOf(value), attributes, (Object)tag);
                return;
            }
            case 9: {
                component.append(String.format("%f", Float.valueOf(((Number)value).floatValue())), attributes, (Object)tag);
                return;
            }
            case 10: {
                component.append(String.format("%f", ((Number)value).doubleValue()), attributes, (Object)tag);
                return;
            }
        }
        Number number = RenderUtils.toJavaIntType(type.getMethod(), (Number)value);
        component.append(String.format("%d", number), attributes, (Object)tag);
    }

    public static void render(@NotNull SnippetObject obj, @NotNull Object[] array, @NotNull Type valueType, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        int count = Math.min(array.length, 3);
        component.append("[", SimpleTextAttributes.GRAY_ATTRIBUTES);
        for (int index = 0; index < count; ++index) {
            if (index > 0) {
                component.append(",", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            Render.render(obj.elem(array[index]), valueType, component, attributes, -1);
        }
        if (count < array.length) {
            component.append("...", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public static void render(@NotNull SnippetObject obj, @NotNull byte[] array, @NotNull Type valueType, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        int count = Math.min(array.length, 3);
        component.append("[", SimpleTextAttributes.GRAY_ATTRIBUTES);
        for (int index = 0; index < count; ++index) {
            if (index > 0) {
                component.append(",", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            Render.render(obj.elem(array[index]), valueType, component, attributes, -1);
        }
        if (count < array.length) {
            component.append("...", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public static void render(@NotNull SnippetObject obj, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int tag) {
        if (obj.getObject() instanceof Dynamic) {
            Render.render(obj, (Dynamic)obj.getObject(), component, attributes, tag);
            return;
        }
        Render.render(obj.getObject(), component, attributes, tag);
    }

    public static int getNodeFieldIndex(@NotNull JTree tree, @NotNull Object node, int x, boolean expanded) {
        ColoredTreeCellRenderer renderer = (ColoredTreeCellRenderer)tree.getCellRenderer();
        renderer.getTreeCellRendererComponent(tree, node, false, expanded, false, 0, false);
        for (int index = renderer.findFragmentAt(x); index >= 2; --index) {
            Object tag = renderer.getFragmentTag(index);
            if (tag == null || !(tag instanceof Integer)) continue;
            return (Integer)tag;
        }
        return -1;
    }
}

