/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.actions.FramebufferTypeAction;
import com.android.tools.idea.editors.gfxtrace.actions.FramebufferWireframeAction;
import com.android.tools.idea.editors.gfxtrace.controllers.ImagePanelController;
import com.android.tools.idea.editors.gfxtrace.models.AtomStream;
import com.android.tools.idea.editors.gfxtrace.service.RenderSettings;
import com.android.tools.idea.editors.gfxtrace.service.ServiceProtos;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ImageInfoPath;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import icons.AndroidIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FrameBufferController
extends ImagePanelController
implements AtomStream.Listener {
    private static final int MAX_SIZE = 65535;
    @NotNull
    private final PathStore<DevicePath> myRenderDevice = new PathStore();
    @NotNull
    private final RenderSettings mySettings = new RenderSettings();
    @NotNull
    private BufferType myBufferType = BufferType.Color;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new FrameBufferController((GfxTraceEditor)editor).myPanel;
    }

    private FrameBufferController(@NotNull GfxTraceEditor editor) {
        super(editor, "Select a frame or command");
        editor.getAtomStream().addListener(this);
        this.mySettings.setMaxHeight(65535);
        this.mySettings.setMaxWidth(65535);
        this.mySettings.setWireframeMode(ServiceProtos.WireframeMode.None);
        this.initToolbar(this.getToolbarActions(), false);
    }

    private DefaultActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new FramebufferTypeAction(this, BufferType.Color, "Color Buffer", "Display the color framebuffer", AndroidIcons.GfxTrace.ColorBuffer));
        group.add((AnAction)new FramebufferTypeAction(this, BufferType.Depth, "Depth Buffer", "Display the depth framebuffer", AndroidIcons.GfxTrace.DepthBuffer));
        group.add((AnAction)new Separator());
        group.add((AnAction)new FramebufferWireframeAction(this, ServiceProtos.WireframeMode.None, "Shaded", "Display the framebuffer with shaded polygons", AndroidIcons.GfxTrace.WireframeNone));
        group.add((AnAction)new FramebufferWireframeAction(this, ServiceProtos.WireframeMode.Overlay, "Shaded + Wireframe", "Display the framebuffer with shaded polygons and overlay the wireframe of the last draw call", AndroidIcons.GfxTrace.WireframeOverlay));
        group.add((AnAction)new FramebufferWireframeAction(this, ServiceProtos.WireframeMode.All, "Wireframe", "Display the framebuffer with wireframes", AndroidIcons.GfxTrace.WireframeAll));
        group.add((AnAction)new Separator());
        return group;
    }

    @NotNull
    public BufferType getBufferType() {
        return this.myBufferType;
    }

    public void setBufferType(@NotNull BufferType bufferType) {
        if (!this.myBufferType.equals((Object)bufferType)) {
            this.myBufferType = bufferType;
            this.updateBuffer();
        }
    }

    @NotNull
    public ServiceProtos.WireframeMode getWireframeMode() {
        return this.mySettings.getWireframeMode();
    }

    public void setWireframeMode(@NotNull ServiceProtos.WireframeMode mode) {
        if (!this.mySettings.getWireframeMode().equals((Object)mode)) {
            this.mySettings.setWireframeMode(mode);
            this.updateBuffer();
        }
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        if (this.myRenderDevice.updateIfNotNull(event.findDevicePath())) {
            this.updateBuffer();
        }
    }

    @Override
    public void onAtomLoadingStart(AtomStream atoms) {
        this.setImage(null);
    }

    @Override
    public void onAtomLoadingComplete(AtomStream atoms) {
    }

    @Override
    public void onAtomsSelected(AtomRangePath path) {
        this.updateBuffer();
    }

    private void updateBuffer() {
        AtomRangePath atomPath = this.myEditor.getAtomStream().getSelectedAtomsPath();
        if (atomPath != null) {
            this.setImage(FetchedImage.load(this.myEditor.getClient(), this.getImageInfoPath(atomPath.getPathToLast())));
        }
    }

    private ListenableFuture<ImageInfoPath> getImageInfoPath(AtomPath atomPath) {
        switch (this.myBufferType) {
            case Color: {
                return this.myEditor.getClient().getFramebufferColor(this.myRenderDevice.getPath(), atomPath, this.mySettings);
            }
            case Depth: {
                return this.myEditor.getClient().getFramebufferDepth(this.myRenderDevice.getPath(), atomPath);
            }
        }
        return null;
    }

    public static enum BufferType {
        Color,
        Depth;

    }
}

