/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.HashSet;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentationController
extends Controller {
    @NotNull
    private final JPanel myPanel = new JPanel();
    @NotNull
    private final JBScrollPane myScrollPane = new JBScrollPane();
    @NotNull
    private final JTextPane myTextPane = new JTextPane();
    @NotNull
    private Map<String, String> myDocumentationCache = new HashMap<String, String>();
    @NotNull
    private Set<String> myRequestInProgress = new HashSet();
    private String myTargetUrl;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new DocumentationController((GfxTraceEditor)editor).myPanel;
    }

    private DocumentationController(@NotNull GfxTraceEditor editor) {
        super(editor);
        this.myScrollPane.setViewportView((Component)this.myTextPane);
        this.myPanel.add((Component)this.myScrollPane, "Center");
        this.myTextPane.setBorder(BorderFactory.createLineBorder(JBColor.border()));
    }

    public void setDocumentation(final @Nullable String url) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTextPane.setText(null);
        if (url == null || url.isEmpty()) {
            return;
        }
        this.myTargetUrl = url;
        final String cachedCopy = this.myDocumentationCache.get(url);
        if (cachedCopy == null) {
            if (this.myRequestInProgress.contains(url)) {
                return;
            }
            this.myRequestInProgress.add(url);
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                boolean problemEncountered = false;
                String validCopy = cachedCopy;
                if (validCopy == null) {
                    try {
                        URLConnection connection = new URL(url).openConnection();
                        InputStream response = connection.getInputStream();
                        Scanner s = new Scanner(response).useDelimiter("\\A");
                        validCopy = s.hasNext() ? s.next() : "";
                    }
                    catch (MalformedURLException e) {
                        problemEncountered = true;
                    }
                    catch (IOException e) {
                        problemEncountered = true;
                    }
                }
                final String documentation = validCopy;
                final boolean error = problemEncountered;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (error) {
                            DocumentationController.this.myRequestInProgress.remove(url);
                        } else if (url.equals(DocumentationController.this.myTargetUrl)) {
                            DocumentationController.this.myTextPane.setText(documentation);
                        }
                        DocumentationController.this.myDocumentationCache.put(url, documentation);
                    }
                });
            }
        });
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
    }
}

