/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.DeviceInfo;
import com.android.tools.idea.editors.gfxtrace.GapiiLibraryLoader;
import com.android.tools.idea.editors.gfxtrace.GfxTraceUtil;
import com.android.tools.idea.editors.gfxtrace.GfxTracer;
import com.android.tools.idea.editors.gfxtrace.forms.ActivitySelector;
import com.android.tools.idea.editors.gfxtrace.forms.TraceDialog;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.android.tools.idea.monitor.gpu.GpuMonitorView;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Container;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GfxTraceCaptureAction
extends ToggleAction {
    private static final String BUTTON_TEXT = "Launch";
    private static final String NOTIFICATION_LAUNCH_REQUIRES_ROOT_TITLE = "Rooted device required";
    private static final String NOTIFICATION_LAUNCH_REQUIRES_ROOT_CONTENT = "The device needs to be rooted in order to launch an application for GPU tracing.<br/>To trace your own application on a non-rooted device, enable tracing in the run configuration.";
    private static final int ROOT_CHECK_RETRY_INTERVAL_MS = 250;
    private static final int ROOT_CHECK_ATTEMPTS = 15;
    @NotNull
    protected final GpuMonitorView myView;
    private JDialog myActiveForm = null;
    private static JDialog sActiveForm = null;

    public GfxTraceCaptureAction(@NotNull GpuMonitorView view) {
        super(BUTTON_TEXT, "Launch in GFX trace mode", AndroidIcons.GfxTrace.InjectSpy);
        this.myView = view;
    }

    private void ensureRoot(IDevice device, Consumer<IDevice> onSuccess, Runnable onFailure) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                if (device.isRoot()) {
                    onSuccess.accept(device);
                    return;
                }
            }
            catch (Exception ex) {
                onFailure.run();
                return;
            }
            String deviceDebuggable = device.getProperty("ro.debuggable");
            if (deviceDebuggable != null && "0".equals(deviceDebuggable)) {
                onFailure.run();
                return;
            }
            try {
                device.root();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
            for (int attempt = 1; attempt <= 15; ++attempt) {
                Optional<IDevice> rootedDevice = Arrays.stream(bridge.getDevices()).filter(d -> {
                    try {
                        return d.getSerialNumber().equals(device.getSerialNumber()) && d.isOnline() && d.isRoot() && d.hasClients();
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }).findFirst();
                if (rootedDevice.isPresent()) {
                    onSuccess.accept(rootedDevice.get());
                    return;
                }
                try {
                    Thread.sleep(250L);
                    continue;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            onFailure.run();
        });
    }

    private void rootingFailed() {
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)new Notification("GPU Trace", NOTIFICATION_LAUNCH_REQUIRES_ROOT_TITLE, NOTIFICATION_LAUNCH_REQUIRES_ROOT_CONTENT, NotificationType.ERROR)));
        this.onStop();
    }

    void start(@NotNull Container window, @NotNull IDevice device) {
        this.ensureRoot(device, rootedDevice -> this.showLauncher(window, (IDevice)rootedDevice, GfxTraceCaptureAction.getSelectedRunConfiguration(this.myView)), this::rootingFailed);
    }

    private void showLauncher(Component owner, final IDevice device, final RunConfiguration runConfig) {
        DeviceInfo.PkgInfoProvider provider = new DeviceInfo.PkgInfoProvider(device);
        final ActivitySelector selector = new ActivitySelector(provider);
        selector.setListener(new ActivitySelector.Listener(){

            @Override
            public void OnLaunch(DeviceInfo.Package pkg, DeviceInfo.Activity act, String name) {
                GfxTraceCaptureAction.this.showTraceDialog(selector, device, pkg, act, runConfig, name);
            }

            @Override
            public void OnCancel() {
                GfxTraceCaptureAction.this.onStop();
            }
        });
        selector.setLocationRelativeTo(owner);
        selector.setTitle("Launch activity...");
        selector.setVisible(true);
        this.setActiveForm(selector);
    }

    private void showTraceDialog(Component owner, final IDevice device, final DeviceInfo.Package pkg, final DeviceInfo.Activity act, final RunConfiguration runConfig, String name) {
        final TraceDialog dialog = new TraceDialog();
        dialog.setListener(new TraceDialog.Listener(){
            private GfxTracer myTracer = null;
            private long myTraceStartTime;

            @Override
            public void onStartTrace(@NotNull String name) {
                GfxTracer.Options options = GfxTracer.Options.fromRunConfiguration(runConfig);
                options.myTraceName = name;
                this.myTraceStartTime = System.currentTimeMillis();
                GfxTraceUtil.trackEvent("gfxTraceStarted", null, null);
                this.myTracer = GfxTracer.launch(GfxTraceCaptureAction.this.myView.getProject(), device, pkg, act, options, GfxTraceCaptureAction.bindListener(dialog));
            }

            @Override
            public void onStopTrace() {
                if (this.myTracer != null) {
                    long totalTime = System.currentTimeMillis() - this.myTraceStartTime;
                    GfxTraceUtil.trackEvent("gfxTraceStopped", null, (int)totalTime);
                    this.myTracer.stop();
                }
                GfxTraceCaptureAction.this.onStop();
            }

            @Override
            public void onCancelTrace() {
                GfxTraceCaptureAction.this.onStop();
            }
        });
        dialog.setLocationRelativeTo(owner);
        dialog.setDefaultName(name.isEmpty() ? pkg.getDisplayName() : name);
        dialog.setVisible(true);
        this.setActiveForm(dialog);
        dialog.onBegin();
    }

    public boolean isSelected(AnActionEvent e) {
        return sActiveForm != null && sActiveForm == this.myActiveForm;
    }

    public final void setSelected(AnActionEvent e, boolean state) {
        if (!GfxTraceUtil.checkAndTryInstallGapidSdkComponent(this.myView.getProject())) {
            return;
        }
        IDevice device = this.myView.getDeviceContext().getSelectedDevice();
        if (device == null) {
            return;
        }
        if (this.myActiveForm == sActiveForm) {
            if (sActiveForm != null) {
                this.myActiveForm.setVisible(true);
            } else {
                Container window = ((JComponent)e.getInputEvent().getSource()).getTopLevelAncestor();
                this.start(window, device);
            }
        }
    }

    public final void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (!GapiPaths.isValid()) {
            presentation.setText("Launch : GPU debugger tools not installed");
        } else {
            presentation.setEnabled(this.isEnabled());
            presentation.setText(BUTTON_TEXT);
        }
    }

    @Nullable
    private static RunConfiguration getSelectedRunConfiguration(@NotNull GpuMonitorView view) {
        Project project = view.getProject();
        RunManager runMgr = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings selected = runMgr.getSelectedConfiguration();
        if (selected == null) {
            return null;
        }
        return selected.getConfiguration();
    }

    private IDevice getDevice() {
        return this.myView.getDeviceContext().getSelectedDevice();
    }

    boolean isEnabled() {
        if (sActiveForm == null || sActiveForm == this.myActiveForm) {
            IDevice device = this.getDevice();
            return device != null && device.isOnline();
        }
        return false;
    }

    protected void setActiveForm(JDialog form) {
        this.myActiveForm = form;
        sActiveForm = form;
    }

    protected void onStop() {
        this.setActiveForm(null);
    }

    public static GfxTracer.Listener bindListener(final TraceDialog dialog) {
        return new GfxTracer.Listener(){
            @NotNull
            private String myCurrentAction = "";
            private long mySizeInBytes = 0L;

            @Override
            public void onAction(final @NotNull String name) {
                EdtExecutor.INSTANCE.execute(new Runnable(){

                    @Override
                    public void run() {
                        myCurrentAction = name;
                        this.update();
                    }
                });
            }

            @Override
            public void onProgress(final long sizeInBytes) {
                EdtExecutor.INSTANCE.execute(new Runnable(){

                    @Override
                    public void run() {
                        mySizeInBytes = sizeInBytes;
                        this.update();
                    }
                });
            }

            @Override
            public void onStopped() {
                dialog.onStop();
            }

            @Override
            public void onError(@NotNull Exception error) {
                String message;
                if (error instanceof GapiiLibraryLoader.DeviceNotSupportedException) {
                    message = "The GPU debugger does not currently support tracing on this device";
                    Logger.getInstance(GfxTraceCaptureAction.class).warn((Throwable)error);
                } else {
                    message = error.getMessage();
                    Logger.getInstance(GfxTraceCaptureAction.class).error((Throwable)error);
                }
                EdtExecutor.INSTANCE.execute(() -> dialog.onError(message));
            }

            private void update() {
                long KB = 1024L;
                long MB = 0x100000L;
                long GB = 0x40000000L;
                String details = "";
                if (this.mySizeInBytes > 0L) {
                    details = this.mySizeInBytes < 1024L ? String.format("%d bytes", this.mySizeInBytes) : (this.mySizeInBytes < 0x100000L ? String.format("%.2f KB", Float.valueOf((float)this.mySizeInBytes / 1024.0f)) : (this.mySizeInBytes < 0x40000000L ? String.format("%.2f MB", Float.valueOf((float)this.mySizeInBytes / 1048576.0f)) : String.format("%.2f GB", Float.valueOf((float)this.mySizeInBytes / 1.0737418E9f))));
                }
                dialog.onProgress(this.myCurrentAction, details);
            }
        };
    }
}

