/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenshot;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.RawImage;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ScreenshotTask
extends Task.Modal {
    private final IDevice myDevice;
    private String myError;
    private BufferedImage myImage;

    public ScreenshotTask(@NotNull Project project, @NotNull IDevice device) {
        super(project, AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]), true);
        this.myDevice = device;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        RawImage rawImage;
        indicator.setIndeterminate(true);
        indicator.setText(AndroidBundle.message("android.ddms.screenshot.task.step.obtain", new Object[0]));
        ScreenshotRetrieverTask retrieverTask = new ScreenshotRetrieverTask(this.myDevice);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)retrieverTask);
        Future<RawImage> image = retrieverTask.getRawImage();
        while (true) {
            try {
                rawImage = image.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.myError = AndroidBundle.message("android.ddms.screenshot.task.error1", ExceptionUtil.getMessage((Throwable)e));
                return;
            }
            catch (ExecutionException e) {
                this.myError = AndroidBundle.message("android.ddms.screenshot.task.error1", ExceptionUtil.getMessage((Throwable)e));
                return;
            }
            catch (TimeoutException e) {
                if (!indicator.isCanceled()) continue;
                return;
            }
            break;
        }
        if (rawImage.bpp != 16 && rawImage.bpp != 32) {
            this.myError = AndroidBundle.message("android.ddms.screenshot.task.error.invalid.bpp", rawImage.bpp);
            return;
        }
        indicator.setText(AndroidBundle.message("android.ddms.screenshot.task.step.load", new Object[0]));
        this.myImage = new BufferedImage(rawImage.width, rawImage.height, 2);
        for (int y = 0; y < rawImage.height; ++y) {
            for (int x = 0; x < rawImage.width; ++x) {
                int argb = rawImage.getARGB((x + y * rawImage.width) * (rawImage.bpp / 8));
                this.myImage.setRGB(x, y, argb);
            }
        }
    }

    public BufferedImage getScreenshot() {
        return this.myImage;
    }

    public String getError() {
        return this.myError;
    }

    private static class ScreenshotRetrieverTask
    implements Runnable {
        private final IDevice myDevice;
        private final SettableFuture<RawImage> myFuture;

        public ScreenshotRetrieverTask(@NotNull IDevice device) {
            this.myDevice = device;
            this.myFuture = SettableFuture.create();
        }

        @Override
        public void run() {
            try {
                RawImage image = this.myDevice.getScreenshot(10L, TimeUnit.SECONDS);
                this.myFuture.set((Object)image);
            }
            catch (Throwable t) {
                this.myFuture.setException(t);
            }
        }

        public Future<RawImage> getRawImage() {
            return this.myFuture;
        }
    }
}

