/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.adb;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tools.idea.ddms.adb.AdbLogOutput;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.android.actions.AndroidEnableAdbServiceAction;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(AdbService.class);
    @Nullable
    private ListenableFuture<AndroidDebugBridge> myFuture;
    private static final Object ADB_INIT_LOCK = new Object();

    public static AdbService getInstance() {
        return (AdbService)ServiceManager.getService(AdbService.class);
    }

    private AdbService() {
        DdmPreferences.setLogLevel((String)Log.LogLevel.INFO.getStringValue());
        DdmPreferences.setTimeOut((int)3000000);
        Log.addLogger((Log.ILogOutput)new AdbLogOutput.SystemLogRedirecter());
    }

    public void dispose() {
        this.terminateDdmlib();
    }

    public synchronized ListenableFuture<AndroidDebugBridge> getDebugBridge(@NotNull File adb) {
        if (this.myFuture != null && this.myFuture.isDone() && !AdbService.wasSuccessful(this.myFuture)) {
            this.terminateDdmlib();
        }
        if (this.myFuture == null) {
            Future future = ApplicationManager.getApplication().executeOnPooledThread((Callable)new CreateBridgeTask(adb));
            this.myFuture = AdbService.makeTimedFuture(future, 20L, TimeUnit.SECONDS);
        }
        return this.myFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminateDdmlib() {
        if (this.myFuture != null) {
            this.myFuture.cancel(true);
            this.myFuture = null;
        }
        Object object = ADB_INIT_LOCK;
        synchronized (object) {
            AndroidDebugBridge.disconnectBridge();
            AndroidDebugBridge.terminate();
        }
    }

    public static boolean canDdmsBeCorrupted(@NotNull AndroidDebugBridge bridge) {
        return AdbService.isDdmsCorrupted(bridge) || AdbService.allDevicesAreEmpty(bridge);
    }

    private static boolean allDevicesAreEmpty(@NotNull AndroidDebugBridge bridge) {
        for (IDevice device : bridge.getDevices()) {
            if (device.getClients().length <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isDdmsCorrupted(@NotNull AndroidDebugBridge bridge) {
        IDevice[] devices = bridge.getDevices();
        if (devices.length > 0) {
            for (IDevice device : devices) {
                Client[] clients = device.getClients();
                if (clients.length <= 0) continue;
                ClientData clientData = clients[0].getClientData();
                return clientData.getVmIdentifier() == null;
            }
        }
        return false;
    }

    public synchronized ListenableFuture<AndroidDebugBridge> restartDdmlib(@NotNull Project project) {
        this.terminateDdmlib();
        File adb = AndroidSdkUtils.getAdb(project);
        if (adb == null) {
            throw new RuntimeException("Unable to locate Android SDK used by project: " + project.getName());
        }
        return this.getDebugBridge(adb);
    }

    private static boolean wasSuccessful(Future<AndroidDebugBridge> future) {
        if (!future.isDone()) {
            return false;
        }
        try {
            AndroidDebugBridge bridge = future.get();
            return bridge != null && bridge.isConnected();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static ListenableFuture<AndroidDebugBridge> makeTimedFuture(final @NotNull Future<BridgeConnectionResult> delegate, final long timeout, final @NotNull TimeUnit unit) {
        final SettableFuture future = SettableFuture.create();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    BridgeConnectionResult value = (BridgeConnectionResult)delegate.get(timeout, unit);
                    if (value.error != null) {
                        future.setException((Throwable)new RuntimeException("Unable to create Debug Bridge: " + value.error));
                    } else {
                        future.set((Object)value.bridge);
                    }
                }
                catch (ExecutionException e) {
                    future.setException(e.getCause());
                }
                catch (InterruptedException e) {
                    delegate.cancel(true);
                    future.setException((Throwable)e);
                }
                catch (TimeoutException e) {
                    delegate.cancel(true);
                    future.setException((Throwable)e);
                }
            }
        });
        return future;
    }

    private static class BridgeConnectionResult {
        @Nullable
        public final AndroidDebugBridge bridge;
        @Nullable
        public final String error;

        private BridgeConnectionResult(@Nullable AndroidDebugBridge bridge, @Nullable String error) {
            this.bridge = bridge;
            this.error = error;
        }

        public static BridgeConnectionResult make(@NotNull AndroidDebugBridge bridge) {
            return new BridgeConnectionResult(bridge, null);
        }

        public static BridgeConnectionResult make(@NotNull String error) {
            return new BridgeConnectionResult(null, error);
        }
    }

    private static class CreateBridgeTask
    implements Callable<BridgeConnectionResult> {
        private final File myAdb;

        public CreateBridgeTask(@NotNull File adb) {
            this.myAdb = adb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BridgeConnectionResult call() throws Exception {
            boolean clientSupport = AndroidEnableAdbServiceAction.isAdbServiceEnabled();
            LOG.info("Initializing adb using: " + this.myAdb.getAbsolutePath() + ", client support = " + clientSupport);
            AdbLogOutput.ToStringLogger toStringLogger = new AdbLogOutput.ToStringLogger();
            Log.addLogger((Log.ILogOutput)toStringLogger);
            try {
                AndroidDebugBridge bridge;
                Object object = ADB_INIT_LOCK;
                synchronized (object) {
                    AndroidDebugBridge.init((boolean)clientSupport);
                    bridge = AndroidDebugBridge.createBridge((String)this.myAdb.getPath(), (boolean)false);
                }
                if (bridge == null) {
                    object = BridgeConnectionResult.make("Unable to start adb server: " + toStringLogger.getOutput());
                    return object;
                }
                while (!bridge.isConnected()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        BridgeConnectionResult bridgeConnectionResult = BridgeConnectionResult.make("Timed out attempting to connect to adb: " + toStringLogger.getOutput());
                        Log.removeLogger((Log.ILogOutput)toStringLogger);
                        return bridgeConnectionResult;
                    }
                }
                LOG.info("Successfully connected to adb");
                object = BridgeConnectionResult.make(bridge);
                return object;
            }
            finally {
                Log.removeLogger((Log.ILogOutput)toStringLogger);
            }
        }
    }
}

