/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.Client;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractClientAction;
import com.android.tools.idea.editors.hierarchyview.HierarchyViewCaptureTask;
import com.android.tools.idea.editors.hierarchyview.WindowPickerDialog;
import com.android.tools.idea.editors.hierarchyview.model.ClientWindow;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.AndroidIcons;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchyViewAction
extends AbstractClientAction {
    private final Project myProject;

    public HierarchyViewAction(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        super(deviceContext, AndroidBundle.message("android.ddms.actions.hierarchyview", new Object[0]), AndroidBundle.message("android.ddms.actions.hierarchyview.description", new Object[0]), AndroidIcons.Ddms.HierarchyView);
        this.myProject = project;
    }

    @Override
    protected void performAction(@NotNull Client client) {
        new GetClientWindowsTask(this.myProject, client).queue();
    }

    public static final class GetClientWindowsTask
    extends Task.Backgroundable {
        private final Client myClient;
        private List<ClientWindow> myWindows;

        public GetClientWindowsTask(@Nullable Project project, @NotNull Client client) {
            super(project, "Obtaining Windows");
            this.myClient = client;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            indicator.setIndeterminate(true);
            this.myWindows = ClientWindow.getAll(this.myClient, 5L, TimeUnit.SECONDS);
        }

        public void onSuccess() {
            ClientWindow window;
            String title = "Capture View Hierarchy";
            if (this.myWindows == null) {
                Messages.showErrorDialog((String)("Unable to obtain list of windows used by " + this.myClient.getClientData().getPackageName()), (String)title);
                return;
            }
            if (this.myWindows.isEmpty()) {
                Messages.showErrorDialog((String)("No active windows displayed by " + this.myClient.getClientData().getPackageName()), (String)title);
                return;
            }
            if (this.myWindows.size() == 1) {
                window = this.myWindows.get(0);
            } else {
                WindowPickerDialog pickerDialog = new WindowPickerDialog(this.myProject, this.myClient, this.myWindows);
                if (!pickerDialog.showAndGet()) {
                    return;
                }
                window = pickerDialog.getSelectedWindow();
                if (window == null) {
                    return;
                }
            }
            HierarchyViewCaptureTask captureTask = new HierarchyViewCaptureTask(this.myProject, this.myClient, window);
            captureTask.queue();
        }
    }
}

