/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.LightGeneratedComponentClass;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingComponentClassFinder
extends PsiElementFinder {
    private final DataBindingProjectComponent myComponent;
    private CachedValue<List<PsiClass>> myClasses;

    public DataBindingComponentClassFinder(final DataBindingProjectComponent component) {
        this.myComponent = component;
        this.myClasses = CachedValuesManager.getManager((Project)component.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<List<PsiClass>>(){

            @Nullable
            public CachedValueProvider.Result<List<PsiClass>> compute() {
                ArrayList classes = Lists.newArrayList();
                for (AndroidFacet facet : DataBindingComponentClassFinder.this.myComponent.getDataBindingEnabledFacets()) {
                    if (facet.isLibraryProject()) continue;
                    classes.add(new LightGeneratedComponentClass(PsiManager.getInstance((Project)component.getProject()), facet));
                }
                return CachedValueProvider.Result.create((Object)classes, (Object[])new Object[]{DataBindingComponentClassFinder.this.myComponent, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        }, false);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, final @NotNull GlobalSearchScope scope) {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet() || !"android.databinding.DataBindingComponent".equals(qualifiedName)) {
            return null;
        }
        return (PsiClass)Iterables.tryFind((Iterable)((Iterable)this.myClasses.getValue()), (Predicate)new Predicate<PsiClass>(){

            public boolean apply(@Nullable PsiClass input) {
                return DataBindingComponentClassFinder.check(input, scope);
            }
        }).orNull();
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, final @NotNull GlobalSearchScope scope) {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet() || !"android.databinding.DataBindingComponent".equals(qualifiedName)) {
            return PsiClass.EMPTY_ARRAY;
        }
        Iterable filtered = Iterables.filter((Iterable)((Iterable)this.myClasses.getValue()), (Predicate)new Predicate<PsiClass>(){

            public boolean apply(@Nullable PsiClass input) {
                return DataBindingComponentClassFinder.check(input, scope);
            }
        });
        if (filtered.iterator().hasNext()) {
            return (PsiClass[])Iterables.toArray((Iterable)filtered, PsiClass.class);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    private static boolean check(@Nullable PsiClass psiClass, @NotNull GlobalSearchScope scope) {
        return psiClass != null && psiClass.getProject() == scope.getProject();
    }
}

