/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingClassFinder
extends PsiElementFinder {
    private final DataBindingProjectComponent myComponent;

    public DataBindingClassFinder(DataBindingProjectComponent component) {
        this.myComponent = component;
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return null;
        }
        for (AndroidFacet facet : this.myComponent.getDataBindingEnabledFacets()) {
            DataBindingInfo dataBindingInfo;
            Map<String, DataBindingInfo> dataBindingResourceFiles;
            LocalResourceRepository moduleResources = facet.getModuleResources(true);
            if (moduleResources == null || (dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles()) == null || (dataBindingInfo = dataBindingResourceFiles.get(qualifiedName)) == null) continue;
            return DataBindingUtil.getOrCreatePsiClass(dataBindingInfo);
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass aClass = this.findClass(qualifiedName, scope);
        if (aClass == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        return new PsiClass[]{aClass};
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        return null;
    }
}

