/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrShortNamesCache
extends PsiShortNamesCache {
    private final DataBindingProjectComponent myComponent;
    private CachedValue<String[]> myAllFieldNamesCache;
    private static final String[] BR_CLASS_NAME_LIST = new String[]{"BR"};

    public BrShortNamesCache(DataBindingProjectComponent dataBindingProjectComponent) {
        this.myComponent = dataBindingProjectComponent;
        this.myAllFieldNamesCache = CachedValuesManager.getManager((Project)this.myComponent.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<String[]>(){

            @Nullable
            public CachedValueProvider.Result<String[]> compute() {
                String[] result;
                AndroidFacet[] facets = BrShortNamesCache.this.myComponent.getDataBindingEnabledFacets();
                if (facets.length == 0) {
                    result = ArrayUtil.EMPTY_STRING_ARRAY;
                } else {
                    java.util.HashSet allFields = Sets.newHashSet();
                    for (AndroidFacet facet : facets) {
                        DataBindingUtil.LightBrClass brClass = DataBindingUtil.getOrCreateBrClassFor(facet);
                        Collections.addAll(allFields, brClass.getAllFieldNames());
                    }
                    result = ArrayUtil.toStringArray((Collection)allFields);
                }
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{BrShortNamesCache.this.myComponent});
            }
        }, false);
    }

    private boolean isMyScope(GlobalSearchScope scope) {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return false;
        }
        if (scope.getProject() == null) {
            return false;
        }
        return this.myComponent.getProject().equals(scope.getProject());
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (!this.isMyScope(scope)) {
            return PsiClass.EMPTY_ARRAY;
        }
        if (!"BR".equals(name)) {
            return PsiClass.EMPTY_ARRAY;
        }
        AndroidFacet[] facets = this.myComponent.getDataBindingEnabledFacets();
        return BrShortNamesCache.filterByScope(facets, scope);
    }

    @NotNull
    public String[] getAllClassNames() {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return BR_CLASS_NAME_LIST;
    }

    public void getAllClassNames(@NotNull HashSet<String> dest) {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return;
        }
        dest.add((Object)"BR");
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope) {
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        PsiField[] fields = this.getFieldsByName(name, scope);
        if (fields.length > maxCount) {
            return PsiField.EMPTY_ARRAY;
        }
        return fields;
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        return true;
    }

    @NotNull
    public String[] getAllMethodNames() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set) {
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (!this.isMyScope(scope)) {
            return PsiField.EMPTY_ARRAY;
        }
        PsiClass[] psiClasses = BrShortNamesCache.filterByScope(this.myComponent.getDataBindingEnabledFacets(), scope);
        if (psiClasses.length == 0) {
            return PsiField.EMPTY_ARRAY;
        }
        ArrayList result = Lists.newArrayList();
        for (PsiClass psiClass : psiClasses) {
            PsiField field = psiClass.findFieldByName(name, false);
            if (field == null) continue;
            result.add(field);
        }
        return result.toArray(new PsiField[result.size()]);
    }

    @NotNull
    public String[] getAllFieldNames() {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return (String[])this.myAllFieldNamesCache.getValue();
    }

    public void getAllFieldNames(@NotNull HashSet<String> set) {
        Collections.addAll(set, this.getAllFieldNames());
    }

    private static PsiClass[] filterByScope(AndroidFacet[] facets, @NotNull GlobalSearchScope scope) {
        if (facets == null || facets.length == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList selected = Lists.newArrayList();
        for (AndroidFacet facet : facets) {
            if (!scope.isSearchInModuleContent(facet.getModule())) continue;
            selected.add(DataBindingUtil.getOrCreateBrClassFor(facet));
        }
        if (selected.size() == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        return selected.toArray(new PsiClass[selected.size()]);
    }
}

