/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.targets.PlatformTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationProjectState;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SoftValueHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.uipreview.UserDeviceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationManager
implements Disposable {
    @NotNull
    private final Module myModule;
    private List<Device> myDevices;
    private Map<String, Device> myDeviceMap;
    private final UserDeviceManager myUserDeviceManager;
    private final SoftValueHashMap<VirtualFile, Configuration> myCache = new SoftValueHashMap();
    private List<Locale> myLocales;
    private Device myDefaultDevice;
    private Locale myLocale;
    private IAndroidTarget myTarget;
    private int myStateVersion;
    private ResourceResolverCache myResolverCache;
    private long myLocaleCacheStamp;

    private ConfigurationManager(@NotNull Module module) {
        this.myModule = module;
        this.myUserDeviceManager = new UserDeviceManager(){

            @Override
            protected void userDevicesChanged() {
                ConfigurationManager.this.myDevices = null;
                ConfigurationManager.this.myDeviceMap = null;
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myUserDeviceManager);
        Disposer.register((Disposable)this.myModule, (Disposable)this);
    }

    @NotNull
    public Configuration getConfiguration(@NotNull VirtualFile file) {
        Configuration configuration = (Configuration)this.myCache.get((Object)file);
        if (configuration == null) {
            configuration = this.create(file);
            this.myCache.put((Object)file, (Object)configuration);
        }
        return configuration;
    }

    boolean hasCachedConfiguration(@NotNull VirtualFile file) {
        return this.myCache.get((Object)file) != null;
    }

    @NotNull
    private Configuration create(@NotNull VirtualFile file) {
        ConfigurationStateManager stateManager = this.getStateManager();
        ConfigurationFileState fileState = stateManager.getConfigurationState(file);
        assert (file.getParent() != null) : file;
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)file.getParent().getName());
        if (config == null) {
            config = new FolderConfiguration();
        }
        Configuration configuration = Configuration.create(this, file, fileState, config);
        AppResourceRepository resources = AppResourceRepository.getAppResources(this.myModule, true);
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration, resources, file);
        if (fileState != null) {
            matcher.adaptConfigSelection(true);
        } else {
            matcher.findAndSetCompatibleConfig(false);
        }
        return configuration;
    }

    @NotNull
    public Configuration createSimilar(@NotNull VirtualFile file, @NotNull VirtualFile baseFile) {
        ConfigurationStateManager stateManager = this.getStateManager();
        ConfigurationFileState fileState = stateManager.getConfigurationState(baseFile);
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)file.getParent().getName());
        if (config == null) {
            config = new FolderConfiguration();
        }
        Configuration configuration = Configuration.create(this, file, fileState, config);
        Configuration baseConfig = (Configuration)this.myCache.get((Object)file);
        if (baseConfig != null) {
            configuration.setEffectiveDevice(baseConfig.getDevice(), baseConfig.getDeviceState());
        }
        AppResourceRepository resources = AppResourceRepository.getAppResources(this.myModule, true);
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration, resources, file);
        matcher.adaptConfigSelection(true);
        this.myCache.put((Object)file, (Object)configuration);
        return configuration;
    }

    public ConfigurationStateManager getStateManager() {
        return ConfigurationStateManager.get(this.myModule.getProject());
    }

    @NotNull
    public static ConfigurationManager create(@NotNull Module module) {
        return new ConfigurationManager(module);
    }

    @NotNull
    public List<Device> getDevices() {
        if (this.myDevices == null || this.myDevices.isEmpty()) {
            ArrayList<Device> devices = null;
            AndroidPlatform platform = AndroidPlatform.getInstance(this.myModule);
            if (platform != null) {
                AndroidSdkData sdkData = platform.getSdkData();
                devices = new ArrayList<Device>();
                DeviceManager deviceManager = sdkData.getDeviceManager();
                devices.addAll(deviceManager.getDevices(EnumSet.of(DeviceManager.DeviceFilter.DEFAULT, DeviceManager.DeviceFilter.VENDOR)));
                devices.addAll(this.myUserDeviceManager.parseUserDevices((ILogger)new MessageBuildingSdkLog()));
            }
            this.myDevices = devices == null ? Collections.emptyList() : devices;
        }
        return this.myDevices;
    }

    @NotNull
    private Map<String, Device> getDeviceMap() {
        if (this.myDeviceMap == null) {
            List<Device> devices = this.getDevices();
            this.myDeviceMap = Maps.newHashMapWithExpectedSize((int)devices.size());
            for (Device device : devices) {
                this.myDeviceMap.put(device.getId(), device);
            }
        }
        return this.myDeviceMap;
    }

    @Nullable
    public Device getDeviceById(@NotNull String id) {
        return this.getDeviceMap().get(id);
    }

    @Nullable
    public Device createDeviceForAvd(@NotNull AvdInfo avd) {
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        assert (facet != null);
        for (Device device : this.getDevices()) {
            if (!device.getManufacturer().equals(avd.getDeviceManufacturer()) || !device.getId().equals(avd.getDeviceName()) && !device.getDisplayName().equals(avd.getDeviceName())) continue;
            String avdName = avd.getName();
            Device.Builder builder = new Device.Builder(device);
            builder.setName(avdName);
            return builder.build();
        }
        return null;
    }

    @NotNull
    public IAndroidTarget[] getTargets() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myModule);
        if (platform != null) {
            AndroidSdkData sdkData = platform.getSdkData();
            return sdkData.getTargets();
        }
        return new IAndroidTarget[0];
    }

    public static boolean isLayoutLibTarget(@NotNull IAndroidTarget target) {
        return target.isPlatform() && target.hasRenderingLibrary();
    }

    @Nullable
    public IAndroidTarget getHighestApiTarget() {
        IAndroidTarget[] targetList = this.getTargets();
        for (int i = targetList.length - 1; i >= 0; --i) {
            IAndroidTarget target = targetList[i];
            if (!ConfigurationManager.isLayoutLibTarget(target) || !ConfigurationManager.isLayoutLibSupported(target)) continue;
            return target;
        }
        return null;
    }

    private static boolean isLayoutLibSupported(IAndroidTarget target) {
        if (target instanceof PlatformTarget) {
            int layoutlibVersion = ((PlatformTarget)target).getLayoutlibApi();
            return layoutlibVersion <= 17;
        }
        return false;
    }

    @NotNull
    public String computePreferredTheme(@NotNull Configuration configuration) {
        MergedManifest manifest = MergedManifest.get(this.myModule);
        String activity = configuration.getActivity();
        if (activity != null) {
            String theme;
            MergedManifest.ActivityAttributes attributes;
            String activityFqcn = activity;
            if (activity.startsWith(".")) {
                String pkg = StringUtil.notNullize((String)manifest.getPackage());
                activityFqcn = pkg + activity;
            }
            if ((attributes = manifest.getActivityAttributes(activityFqcn)) != null && (theme = attributes.getTheme()) != null && theme.startsWith("@")) {
                return theme;
            }
            attributes = manifest.getActivityAttributes(activity);
            if (attributes != null && (theme = attributes.getTheme()) != null && theme.startsWith("@")) {
                return theme;
            }
        }
        return manifest.getDefaultTheme(configuration.getTarget(), configuration.getScreenSize(), configuration.getDevice());
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public Project getProject() {
        return this.myModule.getProject();
    }

    public void dispose() {
    }

    @Nullable
    public Device getDefaultDevice() {
        List<Device> devices;
        if (this.myDefaultDevice == null && !(devices = this.getDevices()).isEmpty()) {
            Device device = devices.get(0);
            for (Device d : devices) {
                String name = d.getId();
                if (name.equals("Nexus 4")) {
                    device = d;
                    break;
                }
                if (!name.equals("Galaxy Nexus")) continue;
                device = d;
            }
            this.myDefaultDevice = device;
        }
        return this.myDefaultDevice;
    }

    @Nullable
    public IAndroidTarget getDefaultTarget() {
        return this.getHighestApiTarget();
    }

    @NotNull
    public List<Locale> getLocales() {
        ProjectResourceRepository projectResources = ProjectResourceRepository.getProjectResources(this.myModule, true);
        assert (projectResources != null);
        if (((LocalResourceRepository)projectResources).getModificationCount() != this.myLocaleCacheStamp) {
            this.myLocales = null;
        }
        if (this.myLocales == null) {
            ArrayList<Locale> locales = new ArrayList<Locale>();
            for (LocaleQualifier locale : projectResources.getLocales()) {
                locales.add(Locale.create(locale));
            }
            this.myLocales = locales;
            this.myLocaleCacheStamp = ((LocalResourceRepository)projectResources).getModificationCount();
        }
        return this.myLocales;
    }

    @Nullable
    public IAndroidTarget getProjectTarget() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myModule);
        return platform != null ? platform.getTarget() : null;
    }

    @NotNull
    public Locale getLocale() {
        if (this.myLocale == null) {
            String localeString = this.getStateManager().getProjectState().getLocale();
            this.myLocale = localeString != null ? ConfigurationProjectState.fromLocaleString(localeString) : Locale.ANY;
        }
        return this.myLocale;
    }

    public void setLocale(@NotNull Locale locale) {
        if (!locale.equals(this.myLocale)) {
            this.myLocale = locale;
            ++this.myStateVersion;
            this.getStateManager().getProjectState().setLocale(ConfigurationProjectState.toLocaleString(locale));
            for (Configuration configuration : this.myCache.values()) {
                configuration.updated(16);
            }
        }
    }

    public List<Device> getRecentDevices() {
        List<String> deviceIds = this.getStateManager().getProjectState().getDeviceIds();
        if (deviceIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList devices = Lists.newArrayListWithExpectedSize((int)deviceIds.size());
        ListIterator<String> iterator = deviceIds.listIterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            Device device = this.getDeviceById(id);
            if (device != null) {
                devices.add(device);
                continue;
            }
            iterator.remove();
        }
        return devices;
    }

    public void selectDevice(@NotNull Device device) {
        String id = device.getId();
        List<String> deviceIds = this.getStateManager().getProjectState().getDeviceIds();
        deviceIds.remove(id);
        deviceIds.add(0, id);
        while (deviceIds.size() > 10) {
            deviceIds.remove(deviceIds.size() - 1);
        }
        ++this.myStateVersion;
        for (Configuration configuration : this.myCache.values()) {
            boolean updateTheme = false;
            String theme = configuration.getTheme();
            if (theme != null && theme.startsWith("@android:style/")) {
                updateTheme = true;
                configuration.startBulkEditing();
                configuration.setTheme(null);
            }
            configuration.updated(2);
            if (!updateTheme) continue;
            configuration.finishBulkEditing();
        }
    }

    @Nullable
    public IAndroidTarget getTarget() {
        if (this.myTarget == null) {
            ConfigurationProjectState projectState = this.getStateManager().getProjectState();
            if (projectState.isPickTarget()) {
                this.myTarget = this.getDefaultTarget();
            } else {
                String targetString = projectState.getTarget();
                this.myTarget = ConfigurationProjectState.fromTargetString(this, targetString);
                if (this.myTarget == null) {
                    this.myTarget = this.getDefaultTarget();
                }
            }
            return this.myTarget;
        }
        return this.myTarget;
    }

    @Nullable
    public IAndroidTarget getTarget(int min) {
        IAndroidTarget target = this.getTarget();
        if (target != null && target.getVersion().getApiLevel() >= min) {
            return target;
        }
        IAndroidTarget[] targetList = this.getTargets();
        for (int i = targetList.length - 1; i >= 0; --i) {
            target = targetList[i];
            if (!ConfigurationManager.isLayoutLibTarget(target) || target.getVersion().getFeatureLevel() < min || !ConfigurationManager.isLayoutLibSupported(target)) continue;
            return target;
        }
        return null;
    }

    public void setTarget(@Nullable IAndroidTarget target) {
        if (target != this.myTarget) {
            AndroidTargetData targetData;
            if (this.myTarget != null && (targetData = AndroidTargetData.getTargetData(this.myTarget, this.myModule)) != null) {
                targetData.clearLayoutBitmapCache(this.myModule);
            }
            this.myTarget = target;
            if (target != null) {
                this.getStateManager().getProjectState().setTarget(ConfigurationProjectState.toTargetString(target));
                ++this.myStateVersion;
                for (Configuration configuration : this.myCache.values()) {
                    configuration.updated(32);
                }
            }
        }
    }

    public void syncToVariations(final int flags, final @NotNull VirtualFile updatedFile, final @NotNull Configuration base, final boolean includeSelf, boolean async) {
        if (async) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ConfigurationManager.this.doSyncToVariations(flags, updatedFile, includeSelf, base);
                }
            });
        } else {
            this.doSyncToVariations(flags, updatedFile, includeSelf, base);
        }
    }

    private void doSyncToVariations(int flags, VirtualFile updatedFile, boolean includeSelf, Configuration base) {
        List<VirtualFile> files = ResourceHelper.getResourceVariations(updatedFile, includeSelf);
        for (VirtualFile file : files) {
            Configuration configuration = this.getConfiguration(file);
            Configuration.copyCompatible(base, configuration);
            configuration.save();
        }
    }

    public int getStateVersion() {
        return this.myStateVersion;
    }

    public ResourceResolverCache getResolverCache() {
        if (this.myResolverCache == null) {
            this.myResolverCache = new ResourceResolverCache(this);
        }
        return this.myResolverCache;
    }
}

