/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Messages;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Icon;

public class InstallSystemImageAction
extends AvdUiAction {
    public InstallSystemImageAction(AvdUiAction.AvdInfoProvider avdInfoProvider) {
        super(avdInfoProvider, "Download", "The corresponding system image is missing", AllIcons.General.BalloonWarning);
    }

    @Override
    public boolean isEnabled() {
        return this.getPackagePath() != null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String path = this.getPackagePath();
        assert (path != null);
        ImmutableList requested = ImmutableList.of((Object)path);
        int response = Messages.showOkCancelDialog((String)"The corresponding system image is missing.\n\nDownload it now?", (String)"Download System Image", (Icon)Messages.getQuestionIcon());
        if (response != 0) {
            return;
        }
        ModelWizardDialog sdkQuickfixWizard = SdkQuickfixUtils.createDialogForPaths(null, (Collection<String>)requested);
        if (sdkQuickfixWizard != null) {
            sdkQuickfixWizard.show();
            this.refreshAvds();
        }
    }

    private String getPackagePath() {
        AvdInfo avdInfo = this.getAvdInfo();
        if (avdInfo == null) {
            return null;
        }
        return AvdManagerConnection.getRequiredSystemImagePath(avdInfo);
    }
}

