/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.tools.idea.assistant.AssistToolWindowFactory;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.structure.services.DeveloperServiceMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.containers.HashSet;
import icons.AndroidIcons;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;

public class OpenAssistSidePanelAction
extends AnAction {
    private static final String TOOL_WINDOW_TITLE = "Assistant";

    public final void actionPerformed(AnActionEvent event) {
        final Project thisProject = event.getProject();
        final String actionId = ActionManager.getInstance().getId((AnAction)this);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)thisProject);
                Module[] modules = moduleManager.getModules();
                HashSet moduleList = new HashSet();
                if (Projects.isBuildWithGradle(thisProject)) {
                    for (Module module : modules) {
                        if (AndroidFacet.getInstance(module) == null) continue;
                        moduleList.add(module);
                    }
                }
                DeveloperServiceMap serviceMap = new DeveloperServiceMap((Set<Module>)moduleList);
                AssistToolWindowFactory factory = new AssistToolWindowFactory(actionId, serviceMap);
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)thisProject);
                ToolWindow toolWindow = toolWindowManager.getToolWindow(OpenAssistSidePanelAction.TOOL_WINDOW_TITLE);
                if (toolWindow == null) {
                    toolWindow = toolWindowManager.registerToolWindow(OpenAssistSidePanelAction.TOOL_WINDOW_TITLE, true, ToolWindowAnchor.RIGHT, (Disposable)thisProject, true);
                }
                toolWindow.setIcon(AndroidIcons.Assistant.Assist);
                factory.createToolWindowContent(thisProject, toolWindow);
                toolWindow.activate(null);
            }
        });
        this.onActionPerformed(event);
    }

    public void onActionPerformed(AnActionEvent event) {
    }
}

