/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.uibuilder.api.XmlBuilder;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlAttribute;
import com.google.devrel.gmscore.tools.apk.arsc.XmlChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlEndElementChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNamespaceEndChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNamespaceStartChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlResourceMapChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlStartElementChunk;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryXmlParser {
    @NotNull
    public static byte[] decodeXml(@NotNull String fileName, @NotNull byte[] bytes) {
        BinaryResourceFile file = new BinaryResourceFile(bytes);
        List chunks = file.getChunks();
        if (chunks.size() != 1) {
            Logger.getInstance(BinaryXmlParser.class).warn("Expected 1, but got " + chunks.size() + " chunks while parsing " + fileName);
            return bytes;
        }
        if (!(chunks.get(0) instanceof XmlChunk)) {
            Logger.getInstance(BinaryXmlParser.class).warn("First chunk in " + fileName + " is not an XmlChunk: " + ((Chunk)chunks.get(0)).getClass().getCanonicalName());
            return bytes;
        }
        XmlPrinter printer = new XmlPrinter();
        XmlChunk xmlChunk = (XmlChunk)chunks.get(0);
        BinaryXmlParser.visitChunks(xmlChunk.getChunks(), printer);
        String reconstructedXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + printer.getReconstructedXml();
        return reconstructedXml.getBytes(Charsets.UTF_8);
    }

    private static void visitChunks(@NotNull Map<Integer, Chunk> chunks, @NotNull XmlChunkHandler handler) {
        List<Chunk> contentChunks = BinaryXmlParser.sortByOffset(chunks);
        for (Chunk chunk : contentChunks) {
            if (chunk instanceof StringPoolChunk) {
                handler.stringPool((StringPoolChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlResourceMapChunk) {
                handler.xmlResourceMap((XmlResourceMapChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlNamespaceStartChunk) {
                handler.startNamespace((XmlNamespaceStartChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlNamespaceEndChunk) {
                handler.endNamespace((XmlNamespaceEndChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlStartElementChunk) {
                handler.startElement((XmlStartElementChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlEndElementChunk) {
                handler.endElement((XmlEndElementChunk)chunk);
                continue;
            }
            Logger.getInstance(BinaryXmlParser.class).warn("XmlNode of type " + chunk.getClass().getCanonicalName() + " not handled.");
        }
    }

    @NotNull
    private static List<Chunk> sortByOffset(Map<Integer, Chunk> contentChunks) {
        ArrayList offsets = Lists.newArrayList(contentChunks.keySet());
        Collections.sort(offsets);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(offsets.size());
        for (Integer offset : offsets) {
            chunks.add(contentChunks.get(offset));
        }
        return chunks;
    }

    public static String formatValue(@NotNull BinaryResourceValue resValue, @Nullable StringPoolChunk stringPool) {
        int data = resValue.data();
        switch (resValue.type()) {
            case NULL: {
                return "null";
            }
            case DYNAMIC_REFERENCE: {
                return String.format(Locale.US, "@dref/0x%1$08x", data);
            }
            case REFERENCE: {
                return String.format(Locale.US, "@ref/0x%1$08x", data);
            }
            case ATTRIBUTE: {
                return String.format(Locale.US, "@attr/0x%1$x", data);
            }
            case STRING: {
                return stringPool != null && stringPool.getStringCount() < data ? stringPool.getString(data) : String.format(Locale.US, "@string/0x%1$x", data);
            }
            case DIMENSION: {
                return String.format(Locale.US, "dimension(%1$d)", data);
            }
            case FRACTION: {
                return String.format(Locale.US, "fraction(%1$d)", data);
            }
            case FLOAT: {
                return String.format(Locale.US, "%f", Float.valueOf(data));
            }
            case INT_DEC: {
                return Integer.toString(data);
            }
            case INT_HEX: {
                return "0x" + Integer.toHexString(data);
            }
            case INT_BOOLEAN: {
                return Boolean.toString(data != 0);
            }
            case INT_COLOR_ARGB8: {
                return String.format("argb8(0x%x)", data);
            }
            case INT_COLOR_RGB8: {
                return String.format("rgb8(0x%x)", data);
            }
            case INT_COLOR_ARGB4: {
                return String.format("argb4(0x%x)", data);
            }
            case INT_COLOR_RGB4: {
                return String.format("rgb4(0x%x)", data);
            }
        }
        return String.format("@res/0x%x", data);
    }

    private static class XmlPrinter
    implements XmlChunkHandler {
        private final XmlBuilder myBuilder;
        private Map<String, String> myNamespaces = new HashMap<String, String>();
        private boolean myNamespacesAdded;
        private StringPoolChunk myStringPool;

        public XmlPrinter() {
            this.myBuilder = new XmlBuilder();
        }

        @Override
        public void stringPool(@NotNull StringPoolChunk chunk) {
            this.myStringPool = chunk;
        }

        @Override
        public void startNamespace(@NotNull XmlNamespaceStartChunk chunk) {
            this.myNamespaces.put(chunk.getUri(), chunk.getPrefix());
        }

        @Override
        public void startElement(@NotNull XmlStartElementChunk chunk) {
            this.myBuilder.startTag(chunk.getName());
            if (!this.myNamespacesAdded && !this.myNamespaces.isEmpty()) {
                this.myNamespacesAdded = true;
                for (Map.Entry entry : this.myNamespaces.entrySet()) {
                    this.myBuilder.attribute("xmlns", (String)entry.getValue(), (String)entry.getKey());
                }
            }
            for (XmlAttribute xmlAttribute : chunk.getAttributes()) {
                String prefix = StringUtil.notNullize((String)this.myNamespaces.get(xmlAttribute.namespace()));
                this.myBuilder.attribute(prefix, xmlAttribute.name(), this.getValue(xmlAttribute));
            }
        }

        @Override
        public void endElement(@NotNull XmlEndElementChunk chunk) {
            this.myBuilder.endTag(chunk.getName());
        }

        @NotNull
        public String getReconstructedXml() {
            return this.myBuilder.toString();
        }

        @NotNull
        private String getValue(@NotNull XmlAttribute attribute) {
            String rawValue = attribute.rawValue();
            if (!StringUtil.isEmpty((String)rawValue)) {
                return rawValue;
            }
            BinaryResourceValue resValue = attribute.typedValue();
            return BinaryXmlParser.formatValue(resValue, this.myStringPool);
        }
    }

    private static interface XmlChunkHandler {
        default public void stringPool(@NotNull StringPoolChunk chunk) {
        }

        default public void xmlResourceMap(@NotNull XmlResourceMapChunk chunk) {
        }

        default public void startNamespace(@NotNull XmlNamespaceStartChunk chunk) {
        }

        default public void endNamespace(@NotNull XmlNamespaceEndChunk chunk) {
        }

        default public void startElement(@NotNull XmlStartElementChunk chunk) {
        }

        default public void endElement(@NotNull XmlEndElementChunk chunk) {
        }
    }
}

