/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.apk.viewer.ApkEntry;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ApkEntryImpl
implements ApkEntry {
    private final VirtualFile myFile;
    @Nullable
    private final String myOriginalName;
    private final long mySize;
    private long myCompressedSize = -1L;

    ApkEntryImpl(@NotNull VirtualFile file, @Nullable String originalName, long size) {
        this.myFile = file;
        this.myOriginalName = originalName;
        this.mySize = size;
    }

    @Override
    public boolean isCompressedSizeKnown() {
        return this.myCompressedSize >= 0L;
    }

    @Override
    public long getCompressedSize() {
        return this.myCompressedSize;
    }

    @Override
    public void setCompressedSize(long compressedSize) {
        this.myCompressedSize = compressedSize;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myOriginalName != null ? this.myOriginalName : this.myFile.getName();
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.myFile.getPath();
    }

    @Override
    public long getSize() {
        return this.mySize;
    }
}

