/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.google.common.base.Splitter;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidApplicationInfo {
    public static final AndroidApplicationInfo UNKNOWN = new AndroidApplicationInfo("unknown", "unknown");
    @NotNull
    public final String packageId;
    @NotNull
    public final String versionName;

    private AndroidApplicationInfo(@NotNull String packageId, @NotNull String versionName) {
        this.packageId = packageId;
        this.versionName = versionName;
    }

    public static AndroidApplicationInfo fromXmlTree(@NotNull ProcessOutput xmlTree) {
        if (xmlTree.getExitCode() != 0) {
            return UNKNOWN;
        }
        return AndroidApplicationInfo.parse(xmlTree.getStdout());
    }

    @NotNull
    static AndroidApplicationInfo parse(@NotNull String output) {
        String packageId = null;
        String versionName = null;
        for (String line : Splitter.on((char)'\n').trimResults().split((CharSequence)output)) {
            int endQuote;
            int eqIndex;
            if (line.startsWith("A: android:versionName")) {
                eqIndex = line.indexOf("=");
                if (eqIndex > 0 && (endQuote = line.indexOf("\"", eqIndex + 2)) > 0) {
                    versionName = line.substring(eqIndex + 2, endQuote);
                }
            } else if (line.startsWith("A: package=") && (eqIndex = line.indexOf("=")) > 0 && (endQuote = line.indexOf("\"", eqIndex + 2)) > 0) {
                packageId = line.substring(eqIndex + 2, endQuote);
            }
            if (packageId == null || versionName == null) continue;
            break;
        }
        return new AndroidApplicationInfo(StringUtil.notNullize(packageId, (String)"unknown"), StringUtil.notNullize(versionName, (String)"?"));
    }
}

