/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.SdkConstants;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AaptInvoker {
    public static final int SUCCESS = 0;
    private static AaptInvoker ourInstance;
    private final Path myAapt;

    private AaptInvoker(@NotNull Path aapt) {
        this.myAapt = aapt;
    }

    @NotNull
    public ProcessOutput getXmlTree(@NotNull File apk, @NotNull String xmlResourcePath) throws ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{this.myAapt.toString(), "dump", "xmltree", apk.getAbsolutePath(), xmlResourcePath});
        return ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine);
    }

    @Nullable
    public static synchronized AaptInvoker getInstance() {
        if (ourInstance != null) {
            return ourInstance;
        }
        Path aapt = AaptInvoker.getPathToAapt();
        if (aapt == null) {
            return null;
        }
        ourInstance = new AaptInvoker(aapt);
        return ourInstance;
    }

    @Nullable
    private static Path getPathToAapt() {
        AndroidSdkHandler sdkHandler = AndroidSdkUtils.tryToChooseSdkHandler();
        BuildToolInfo latestBuildTool = sdkHandler.getLatestBuildTool((ProgressIndicator)new StudioLoggerProgressIndicator(AaptInvoker.class), true);
        if (latestBuildTool == null) {
            return null;
        }
        return latestBuildTool.getLocation().toPath().resolve(SdkConstants.FN_AAPT);
    }
}

