/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageLineMarkerRenderer;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.util.Function;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageEngine {
    public static final ExtensionPointName<CoverageEngine> EP_NAME = ExtensionPointName.create((String)"com.intellij.coverageEngine");

    public abstract boolean isApplicableTo(@Nullable RunConfigurationBase var1);

    public abstract boolean canHavePerTestCoverage(@Nullable RunConfigurationBase var1);

    @NotNull
    public abstract CoverageEnabledConfiguration createCoverageEnabledConfiguration(@Nullable RunConfigurationBase var1);

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @Nullable String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMerge, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders) {
        return this.createCoverageSuite(covRunner, name, coverageDataFileProvider, filters, lastCoverageTimeStamp, suiteToMerge, coverageByTestEnabled, tracingEnabled, trackTestFolders, null);
    }

    @Nullable
    public abstract CoverageSuite createCoverageSuite(@NotNull CoverageRunner var1, @NotNull String var2, @NotNull CoverageFileProvider var3, @Nullable String[] var4, long var5, @Nullable String var7, boolean var8, boolean var9, boolean var10, Project var11);

    @Nullable
    public abstract CoverageSuite createCoverageSuite(@NotNull CoverageRunner var1, @NotNull String var2, @NotNull CoverageFileProvider var3, @NotNull CoverageEnabledConfiguration var4);

    @Nullable
    public abstract CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner var1);

    @NotNull
    public abstract CoverageAnnotator getCoverageAnnotator(Project var1);

    public abstract boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile var1);

    public abstract boolean acceptedByFilters(@NotNull PsiFile var1, @NotNull CoverageSuitesBundle var2);

    @NotNull
    public Set<File> getCorrespondingOutputFiles(@NotNull PsiFile srcFile, @Nullable Module module, @NotNull CoverageSuitesBundle suite) {
        VirtualFile virtualFile = srcFile.getVirtualFile();
        return virtualFile == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
    }

    public abstract boolean recompileProjectAndRerunAction(@NotNull Module var1, @NotNull CoverageSuitesBundle var2, @NotNull Runnable var3);

    @Nullable
    public String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(outputFile);
        if (virtualFile != null) {
            return this.getQualifiedName(virtualFile, sourceFile);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public String getQualifiedName(@NotNull VirtualFile outputFile, @NotNull PsiFile sourceFile) {
        return null;
    }

    @NotNull
    public abstract Set<String> getQualifiedNames(@NotNull PsiFile var1);

    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(outputFile);
        if (virtualFile != null) {
            return this.includeUntouchedFileInCoverage(qualifiedName, virtualFile, sourceFile, suite);
        }
        return false;
    }

    @Deprecated
    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull VirtualFile outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        return false;
    }

    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(classFile);
        if (virtualFile != null) {
            return this.collectSrcLinesForUntouchedFile(virtualFile, suite);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull VirtualFile classFile, @NotNull CoverageSuitesBundle suite) {
        return null;
    }

    public String generateBriefReport(@NotNull Editor editor, @NotNull PsiFile psiFile, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        int hits = lineData == null ? 0 : lineData.getHits();
        return "Hits: " + hits;
    }

    public abstract List<PsiElement> findTestsByNames(@NotNull String[] var1, @NotNull Project var2);

    @Nullable
    public abstract String getTestMethodName(@NotNull PsiElement var1, @NotNull AbstractTestProxy var2);

    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        return false;
    }

    public void generateReport(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
    }

    @NotNull
    public ExportToHTMLDialog createGenerateReportDialog(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        ExportToHTMLDialog dialog = new ExportToHTMLDialog(project, true);
        dialog.setTitle("Generate Coverage Report for: '" + currentSuite.getPresentableName() + "'");
        return dialog;
    }

    public abstract String getPresentableText();

    public boolean coverageProjectViewStatisticsApplicableTo(VirtualFile fileOrDir) {
        return false;
    }

    public Object[] postProcessExecutableLines(Object[] lines, Editor editor) {
        return lines;
    }

    public CoverageLineMarkerRenderer getLineMarkerRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<Integer, Integer> newToOldConverter, Function<Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        return CoverageLineMarkerRenderer.getRenderer(lineNumber, className, lines, coverageByTestApplicable, coverageSuite, newToOldConverter, oldToNewConverter, subCoverageActive);
    }

    public boolean shouldHighlightFullLines() {
        return false;
    }

    public static String getEditorTitle() {
        return "Code Coverage";
    }

    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle, CoverageViewManager.StateBean stateBean) {
        return null;
    }

    public boolean isInLibraryClasses(Project project, VirtualFile file) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return projectFileIndex.isInLibraryClasses(file) && !projectFileIndex.isInSource(file);
    }
}

