/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.ipc.gradle;

import java.io.File;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.foundation.ipc.basic.MessageObject;
import org.gradle.foundation.ipc.gradle.AbstractGradleServerProtocol;

public class ExecuteGradleCommandServerProtocol
extends AbstractGradleServerProtocol {
    private static final String INIT_SCRIPT_NAME = "execute-command-init-script";
    private ExecutionInteraction executionInteraction;

    public ExecuteGradleCommandServerProtocol(File currentDirectory, File gradleHomeDirectory, File customGradleExecutor, String fullCommandLine, LogLevel logLevel, ShowStacktrace stackTraceLevel, ExecutionInteraction executionInteraction) {
        super(currentDirectory, gradleHomeDirectory, customGradleExecutor, fullCommandLine, logLevel, stackTraceLevel);
        this.executionInteraction = executionInteraction;
    }

    protected boolean handleMessageReceived(MessageObject message) {
        if ("ExecutionCompleted".equals(message.getMessageType())) {
            this.setHasReceivedBuildCompleteNotification();
            return true;
        }
        if ("TaskStarted".equals(message.getMessageType())) {
            Float percentComplete = (Float)message.getData();
            this.executionInteraction.reportTaskStarted(message.getMessage(), percentComplete.floatValue());
            return true;
        }
        if ("TaskComplete".equals(message.getMessageType())) {
            Float percentComplete = (Float)message.getData();
            this.executionInteraction.reportTaskComplete(message.getMessage(), percentComplete.floatValue());
            return true;
        }
        if ("LiveOutput".equals(message.getMessageType())) {
            this.executionInteraction.reportLiveOutput(message.getMessage());
            return true;
        }
        if ("NumberOfTasksToExecute".equals(message.getMessageType())) {
            Integer total = (Integer)message.getData();
            this.executionInteraction.reportNumberOfTasksToExecute(total);
        }
        if ("exiting".equals(message.getMessageType())) {
            this.closeConnection();
            return true;
        }
        return false;
    }

    protected void reportClientExit(boolean wasPremature, int returnCode, String output) {
        this.executionInteraction.reportExecutionFinished(returnCode == 0, output, null);
    }

    protected void addStatus(String status) {
        this.executionInteraction.reportLiveOutput(status);
    }

    public File getInitScriptFile() {
        return this.extractInitScriptFile(ExecuteGradleCommandServerProtocol.class, INIT_SCRIPT_NAME);
    }

    public static interface ExecutionInteraction {
        public void reportExecutionStarted();

        public void reportNumberOfTasksToExecute(int var1);

        public void reportExecutionFinished(boolean var1, String var2, Throwable var3);

        public void reportTaskStarted(String var1, float var2);

        public void reportTaskComplete(String var1, float var2);

        public void reportLiveOutput(String var1);
    }
}

