/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestingColumnDuration;
import com.google.gct.testing.results.GoogleCloudTestingColumnResults;
import com.google.gct.testing.results.GoogleCloudTestingColumnTest;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestingStatisticsTableModel
extends ListTableModel<GoogleCloudTestProxy> {
    private static final Logger LOG = Logger.getInstance((String)GoogleCloudTestingStatisticsTableModel.class.getName());
    private GoogleCloudTestProxy myCurrentSuite;

    public GoogleCloudTestingStatisticsTableModel() {
        super(new ColumnInfo[]{new GoogleCloudTestingColumnTest(), new GoogleCloudTestingColumnDuration(), new GoogleCloudTestingColumnResults()});
        this.setSortable(true);
    }

    public void updateModelOnProxySelected(GoogleCloudTestProxy proxy) {
        GoogleCloudTestProxy newCurrentSuite = this.getCurrentSuiteFor(proxy);
        if (this.myCurrentSuite != newCurrentSuite) {
            this.myCurrentSuite = newCurrentSuite;
        }
        SMRunnerUtil.addToInvokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingStatisticsTableModel.this.updateModel();
            }
        });
    }

    @Nullable
    public GoogleCloudTestProxy getTestAt(int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.getItems().size()) {
            return null;
        }
        return (GoogleCloudTestProxy)((Object)this.getItems().get(rowIndex));
    }

    public int getIndexOf(GoogleCloudTestProxy test) {
        for (int i = 0; i < this.getItems().size(); ++i) {
            GoogleCloudTestProxy child = (GoogleCloudTestProxy)((Object)this.getItems().get(i));
            if (child != test) continue;
            return i;
        }
        return -1;
    }

    protected void updateModel() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        this.setItems(this.getItemsForSuite(this.myCurrentSuite));
    }

    @NotNull
    private List<GoogleCloudTestProxy> getItemsForSuite(@Nullable GoogleCloudTestProxy suite) {
        if (suite == null) {
            return Collections.emptyList();
        }
        ArrayList<GoogleCloudTestProxy> list = new ArrayList<GoogleCloudTestProxy>();
        list.addAll(suite.getChildren());
        return list;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        LOG.error("value: " + aValue + " row: " + rowIndex + " column: " + columnIndex);
    }

    @Nullable
    private GoogleCloudTestProxy getCurrentSuiteFor(@Nullable GoogleCloudTestProxy proxy) {
        if (proxy == null) {
            return null;
        }
        GoogleCloudTestProxy suite = proxy.isSuite() ? proxy : proxy.getParent();
        return suite;
    }

    protected boolean shouldUpdateModelByTest(GoogleCloudTestProxy test) {
        return this.isSomeSuiteSelected() && test.getParent() == this.myCurrentSuite;
    }

    protected boolean shouldUpdateModelBySuite(GoogleCloudTestProxy suite) {
        return this.isSomeSuiteSelected() && (suite == this.myCurrentSuite || suite.getParent() == this.myCurrentSuite);
    }

    private boolean isSomeSuiteSelected() {
        return this.myCurrentSuite != null;
    }
}

