/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.CloudMatrixExecutionCancellator;
import com.google.gct.testing.results.GoogleCloudTestEventsProcessor;
import com.google.gct.testing.results.GoogleCloudTestingConsoleView;
import com.google.gct.testing.results.GoogleCloudTestingResultsForm;
import com.google.gct.testing.results.GoogleCloudTestingStatisticsPanel;
import com.google.gct.testing.results.GoogleCloudTestingToSMTRunnerEventsConvertor;
import com.google.gct.testing.results.GoogleCloudTestingUIActionsHandler;
import com.google.gct.testing.results.OutputToGoogleCloudTestEventsConverter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.CompositeTestLocationProvider;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.ui.AttachToProcessListener;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.testIntegration.TestLocationProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestResultsConnectionUtil {
    private static final String TEST_RUNNER_DEBUG_MODE_PROPERTY = "idea.smrunner.debug";

    private GoogleCloudTestResultsConnectionUtil() {
    }

    public static BaseTestsOutputConsoleView createAndAttachConsole(@NotNull String testFrameworkName, @NotNull ProcessHandler processHandler, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) throws ExecutionException {
        BaseTestsOutputConsoleView console = GoogleCloudTestResultsConnectionUtil.createConsole(testFrameworkName, consoleProperties, environment, matrixExecutionCancellator);
        console.attachToProcess(processHandler);
        return console;
    }

    public static BaseTestsOutputConsoleView createConsoleWithCustomLocator(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable TestLocationProvider locator, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        return GoogleCloudTestResultsConnectionUtil.createConsoleWithCustomLocator(testFrameworkName, consoleProperties, environment, (SMTestLocator)new CompositeTestLocationProvider(locator), false, null, matrixExecutionCancellator);
    }

    public static GoogleCloudTestingConsoleView createConsoleWithCustomLocator(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable SMTestLocator locator, boolean idBasedTreeConstruction, @Nullable TestProxyFilterProvider filterProvider, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        String splitterPropertyName = GoogleCloudTestResultsConnectionUtil.getSplitterPropertyName(testFrameworkName);
        GoogleCloudTestingConsoleView consoleView = new GoogleCloudTestingConsoleView(consoleProperties, environment, splitterPropertyName);
        GoogleCloudTestResultsConnectionUtil.initConsoleView(consoleView, testFrameworkName, locator, idBasedTreeConstruction, filterProvider, matrixExecutionCancellator);
        return consoleView;
    }

    @NotNull
    public static String getSplitterPropertyName(@NotNull String testFrameworkName) {
        return testFrameworkName + ".Splitter.Proportion";
    }

    public static void initConsoleView(final @NotNull GoogleCloudTestingConsoleView consoleView, final @NotNull String testFrameworkName, final @Nullable SMTestLocator locator, final boolean idBasedTreeConstruction, final @Nullable TestProxyFilterProvider filterProvider, final @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        consoleView.addAttachToProcessListener(new AttachToProcessListener(){

            public void onAttachToProcess(@NotNull ProcessHandler processHandler) {
                TestProxyPrinterProvider printerProvider = null;
                if (filterProvider != null) {
                    printerProvider = new TestProxyPrinterProvider((BaseTestsOutputConsoleView)consoleView, filterProvider);
                }
                GoogleCloudTestingResultsForm resultsForm = consoleView.getResultsViewer();
                GoogleCloudTestResultsConnectionUtil.attachEventsProcessors(consoleView.getProperties(), resultsForm, resultsForm.getStatisticsPane(), processHandler, testFrameworkName, locator, idBasedTreeConstruction, printerProvider, matrixExecutionCancellator);
            }
        });
        consoleView.setHelpId("reference.runToolWindow.testResultsTab");
        consoleView.initUI();
    }

    public static BaseTestsOutputConsoleView createConsole(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        return GoogleCloudTestResultsConnectionUtil.createConsoleWithCustomLocator(testFrameworkName, consoleProperties, environment, null, matrixExecutionCancellator);
    }

    public static boolean isInDebugMode() {
        return Boolean.valueOf(System.getProperty(TEST_RUNNER_DEBUG_MODE_PROPERTY));
    }

    private static ProcessHandler attachEventsProcessors(@NotNull TestConsoleProperties consoleProperties, GoogleCloudTestingResultsForm resultsViewer, GoogleCloudTestingStatisticsPanel statisticsPane, ProcessHandler processHandler, @NotNull String testFrameworkName, @Nullable SMTestLocator locator, boolean idBasedTreeConstruction, @Nullable TestProxyPrinterProvider printerProvider, final @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        final OutputToGoogleCloudTestEventsConverter outputConsumer = new OutputToGoogleCloudTestEventsConverter(testFrameworkName, consoleProperties);
        if (idBasedTreeConstruction) {
            throw new RuntimeException("ID-based converter is not supported!");
        }
        final GoogleCloudTestingToSMTRunnerEventsConvertor eventsProcessor = new GoogleCloudTestingToSMTRunnerEventsConvertor(resultsViewer.getTestsRootNode(), testFrameworkName);
        if (locator != null) {
            ((GoogleCloudTestEventsProcessor)eventsProcessor).setLocator(locator);
        }
        if (printerProvider != null) {
            ((GoogleCloudTestEventsProcessor)eventsProcessor).setPrinterProvider(printerProvider);
        }
        GoogleCloudTestingUIActionsHandler uiActionsHandler = new GoogleCloudTestingUIActionsHandler(consoleProperties);
        outputConsumer.setProcessor(eventsProcessor);
        ((GoogleCloudTestEventsProcessor)eventsProcessor).addEventsListener(resultsViewer);
        resultsViewer.addEventsListener(uiActionsHandler);
        ((GoogleCloudTestEventsProcessor)eventsProcessor).addEventsListener(statisticsPane.createTestEventsListener());
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                matrixExecutionCancellator.cancel();
                outputConsumer.flushBufferBeforeTerminating();
                eventsProcessor.onFinishTesting();
                Disposer.dispose((Disposable)eventsProcessor);
                Disposer.dispose((Disposable)outputConsumer);
            }

            public void startNotified(ProcessEvent event) {
                eventsProcessor.onStartTesting();
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                outputConsumer.process(event.getText(), outputType);
            }
        });
        return processHandler;
    }
}

