/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import java.lang.reflect.Type;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class Binding {
    static final Logger LOG = Logger.getInstance(Binding.class);
    protected final MutableAccessor myAccessor;

    protected Binding(MutableAccessor accessor) {
        this.myAccessor = accessor;
    }

    @NotNull
    public MutableAccessor getAccessor() {
        return this.myAccessor;
    }

    @Nullable
    public abstract Object serialize(@NotNull Object var1, @Nullable Object var2, @NotNull SerializationFilter var3);

    @Nullable
    public Object deserialize(Object context, @NotNull Element element) {
        return context;
    }

    public boolean isBoundTo(@NotNull Element element) {
        return false;
    }

    void init(@NotNull Type originalType) {
    }

    @Nullable
    public static Object deserializeList(@NotNull Binding binding, Object context, @NotNull List<Element> nodes) {
        if (binding instanceof MultiNodeBinding) {
            return ((MultiNodeBinding)((Object)binding)).deserializeList(context, nodes);
        }
        if (nodes.size() == 1) {
            return binding.deserialize(context, nodes.get(0));
        }
        if (nodes.isEmpty()) {
            return null;
        }
        throw new AssertionError((Object)("Duplicate data for " + binding + " will be ignored"));
    }
}

