/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MessageBusImpl
implements MessageBus {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusImpl");
    private static final Comparator<MessageBusImpl> MESSAGE_BUS_COMPARATOR = new Comparator<MessageBusImpl>(){

        @Override
        public int compare(MessageBusImpl bus1, MessageBusImpl bus2) {
            return ContainerUtil.compareLexicographically((List)bus1.myOrderRef.get(), (List)bus2.myOrderRef.get());
        }
    };
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue = MessageBusImpl.createThreadLocalQueue();
    private final AtomicReference<List<Integer>> myOrderRef = new AtomicReference();
    private final ConcurrentMap<Topic, Object> mySyncPublishers = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<Topic, Object> myAsyncPublishers = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscribers = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscriberCache = ContainerUtil.newConcurrentMap();
    private final Deque<MessageBusImpl> myChildBuses = new LinkedBlockingDeque<MessageBusImpl>();
    private final ConcurrentMap<List<Integer>, Boolean> myChildOrders = ContainerUtil.newConcurrentMap();
    private static final Object NA = new Object();
    private MessageBusImpl myParentBus;
    private final String myOwner;
    private boolean myDisposed;
    private final Disposable myConnectionDisposable;

    public MessageBusImpl(@NotNull Object owner, @NotNull MessageBus parentBus) {
        this.myOwner = owner.toString() + " of " + owner.getClass();
        this.myConnectionDisposable = Disposer.newDisposable(this.myOwner);
        this.myParentBus = (MessageBusImpl)parentBus;
        this.myParentBus.onChildBusCreated(this);
        LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
        LOG.assertTrue(this.myOrderRef.get() != null);
    }

    private MessageBusImpl(Object owner) {
        this.myOwner = owner.toString() + " of " + owner.getClass();
        this.myConnectionDisposable = Disposer.newDisposable(this.myOwner);
        this.myOrderRef.set(Collections.emptyList());
    }

    @Override
    public MessageBus getParent() {
        return this.myParentBus;
    }

    @NotNull
    private RootBus getRootBus() {
        return this.myParentBus != null ? this.myParentBus.getRootBus() : this.asRoot();
    }

    private RootBus asRoot() {
        if (this instanceof RootBus) {
            return (RootBus)this;
        }
        throw new AssertionError((Object)("Accessing disposed message bus " + this));
    }

    public String toString() {
        return super.toString() + "; owner=" + this.myOwner + (this.myDisposed ? "; disposed" : "");
    }

    private void onChildBusCreated(MessageBusImpl childBus) {
        LOG.assertTrue(childBus.myParentBus == this);
        ArrayList<Integer> childOrder = new ArrayList<Integer>(this.myOrderRef.get().size() + 1);
        childOrder.addAll((Collection)this.myOrderRef.get());
        childOrder.add(1);
        do {
            int lastChildIndex;
            MessageBusImpl lastChild;
            if ((lastChild = this.myChildBuses.peekLast()) == null) {
                lastChildIndex = 0;
            } else {
                List<Integer> lastChildOrder = lastChild.myOrderRef.get();
                lastChildIndex = lastChildOrder.get(lastChildOrder.size() - 1);
            }
            if (lastChildIndex == Integer.MAX_VALUE) {
                LOG.error("Too many child buses");
            }
            childOrder.set(childOrder.size() - 1, lastChildIndex + 1);
        } while (this.myChildOrders.putIfAbsent(childOrder, Boolean.TRUE) != null);
        childBus.myOrderRef.set(childOrder);
        this.myChildBuses.add(childBus);
        this.getRootBus().clearSubscriberCache();
    }

    private void onChildBusDisposed(MessageBusImpl childBus) {
        boolean removed = this.myChildBuses.remove(childBus);
        this.myChildOrders.remove(childBus.myOrderRef.get());
        Map map = (Map)this.getRootBus().myWaitingBuses.get();
        if (map != null) {
            map.remove(childBus);
        }
        this.getRootBus().clearSubscriberCache();
        LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public MessageBusConnection connect() {
        return this.connect(this.myConnectionDisposable);
    }

    @Override
    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        Disposer.register(parentDisposable, connection);
        return connection;
    }

    @Override
    @NotNull
    public <L> L syncPublisher(final @NotNull Topic<L> topic) {
        this.checkNotDisposed();
        Object publisher = this.mySyncPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    MessageBusImpl.this.sendMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
            publisher = ConcurrencyUtil.cacheOrGet(this.mySyncPublishers, topic, publisher);
        }
        return (L)publisher;
    }

    @Override
    @NotNull
    public <L> L asyncPublisher(final @NotNull Topic<L> topic) {
        this.checkNotDisposed();
        Object publisher = this.myAsyncPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    MessageBusImpl.this.postMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
            publisher = ConcurrencyUtil.cacheOrGet(this.myAsyncPublishers, topic, publisher);
        }
        return (L)publisher;
    }

    @Override
    public void dispose() {
        this.checkNotDisposed();
        Disposer.dispose(this.myConnectionDisposable);
        Queue<DeliveryJob> jobs = this.myMessageQueue.get();
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.onChildBusDisposed(this);
            this.myParentBus = null;
        } else {
            this.asRoot().myWaitingBuses.remove();
        }
        this.myDisposed = true;
    }

    private void checkNotDisposed() {
        if (this.myDisposed) {
            LOG.error("Already disposed: " + this);
        }
    }

    private void calcSubscribers(Topic topic, List<MessageBusConnectionImpl> result) {
        Topic.BroadcastDirection direction;
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers != null) {
            result.addAll(topicSubscribers);
        }
        if ((direction = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBuses) {
                childBus.calcSubscribers(topic, result);
            }
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.calcSubscribers(topic, result);
        }
    }

    private void postMessage(Message message) {
        this.checkNotDisposed();
        Topic topic = message.getTopic();
        SmartList<MessageBusConnectionImpl> topicSubscribers = (SmartList<MessageBusConnectionImpl>)this.mySubscriberCache.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = new SmartList<MessageBusConnectionImpl>();
            this.calcSubscribers(topic, topicSubscribers);
            this.mySubscriberCache.put(topic, topicSubscribers);
        }
        if (!topicSubscribers.isEmpty()) {
            for (MessageBusConnectionImpl subscriber : topicSubscribers) {
                subscriber.getBus().myMessageQueue.get().offer(new DeliveryJob(subscriber, message));
                subscriber.getBus().notifyPendingJobChange(1);
                subscriber.scheduleMessageDelivery(message);
            }
        }
    }

    private void notifyPendingJobChange(int delta) {
        Integer countObject;
        int count;
        int newCount;
        ThreadLocal ref = this.getRootBus().myWaitingBuses;
        TreeMap<MessageBusImpl, Integer> map = (TreeMap<MessageBusImpl, Integer>)ref.get();
        if (map == null) {
            map = new TreeMap<MessageBusImpl, Integer>(MESSAGE_BUS_COMPARATOR);
            ref.set(map);
        }
        if ((newCount = (count = (countObject = (Integer)map.get(this)) == null ? 0 : countObject) + delta) > 0) {
            this.checkNotDisposed();
            map.put(this, newCount);
        } else if (newCount == 0) {
            map.remove(this);
        } else {
            LOG.error("Negative job count: " + this);
        }
    }

    private void sendMessage(Message message) {
        this.pumpMessages();
        this.postMessage(message);
        this.pumpMessages();
    }

    private void pumpMessages() {
        this.checkNotDisposed();
        if (this.myParentBus != null) {
            LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
            this.myParentBus.pumpMessages();
        } else {
            Set buses;
            Map map = (Map)this.asRoot().myWaitingBuses.get();
            if (map != null && !(buses = map.keySet()).isEmpty()) {
                for (MessageBusImpl bus : new ArrayList(buses)) {
                    if (bus.myDisposed) {
                        map.remove(bus);
                        LOG.error("Accessing disposed message bus " + bus);
                        continue;
                    }
                    bus.doPumpMessages();
                }
            }
        }
    }

    private void doPumpMessages() {
        DeliveryJob job;
        Queue<DeliveryJob> queue = this.myMessageQueue.get();
        while ((job = queue.poll()) != null) {
            this.notifyPendingJobChange(-1);
            job.connection.deliverMessage(job.message);
        }
    }

    void notifyOnSubscription(MessageBusConnectionImpl connection, Topic topic) {
        this.checkNotDisposed();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createLockFreeCopyOnWriteList();
            topicSubscribers = ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, topicSubscribers);
        }
        topicSubscribers.add(connection);
        this.getRootBus().clearSubscriberCache();
    }

    void clearSubscriberCache() {
        this.mySubscriberCache.clear();
        for (MessageBusImpl bus : this.myChildBuses) {
            bus.clearSubscriberCache();
        }
    }

    void notifyConnectionTerminated(MessageBusConnectionImpl connection) {
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        if (this.myDisposed) {
            return;
        }
        this.getRootBus().clearSubscriberCache();
        Iterator i = this.myMessageQueue.get().iterator();
        while (i.hasNext()) {
            DeliveryJob job = (DeliveryJob)i.next();
            if (job.connection != connection) continue;
            i.remove();
            this.notifyPendingJobChange(-1);
        }
    }

    void deliverSingleMessage() {
        this.checkNotDisposed();
        DeliveryJob job = this.myMessageQueue.get().poll();
        if (job == null) {
            return;
        }
        this.notifyPendingJobChange(-1);
        job.connection.deliverMessage(job.message);
    }

    @NotNull
    static <T> ThreadLocal<Queue<T>> createThreadLocalQueue() {
        return new ThreadLocal<Queue<T>>(){

            @Override
            protected Queue<T> initialValue() {
                return new ConcurrentLinkedQueue();
            }
        };
    }

    public static class RootBus
    extends MessageBusImpl {
        private final ThreadLocal<SortedMap<MessageBusImpl, Integer>> myWaitingBuses = new ThreadLocal();

        public RootBus(@NotNull Object owner) {
            super(owner);
        }
    }

    private static class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        public DeliveryJob(MessageBusConnectionImpl connection, Message message) {
            this.connection = connection;
            this.message = message;
        }

        @NonNls
        public String toString() {
            return "{ DJob connection:" + this.connection.toString() + "; message: " + this.message + " }";
        }
    }
}

