/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.ArrayBackedFMap;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.OneElementFMap;
import org.jetbrains.annotations.NotNull;

public class PairElementsFMap
implements KeyFMap {
    private final Key key1;
    private final Key key2;
    private final Object value1;
    private final Object value2;

    PairElementsFMap(@NotNull Key key1, @NotNull Object value1, @NotNull Key key2, @NotNull Object value2) {
        this.key1 = key1;
        this.value1 = value1;
        this.key2 = key2;
        this.value2 = value2;
        assert (key1 != key2);
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        if (key == this.key1) {
            return new PairElementsFMap(key, value, this.key2, this.value2);
        }
        if (key == this.key2) {
            return new PairElementsFMap(key, value, this.key1, this.value1);
        }
        return new ArrayBackedFMap(new int[]{this.key1.hashCode(), this.key2.hashCode(), key.hashCode()}, new Object[]{this.value1, this.value2, value});
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == this.key1) {
            return new OneElementFMap<Object>(this.key2, this.value2);
        }
        if (key == this.key2) {
            return new OneElementFMap<Object>(this.key1, this.value1);
        }
        return this;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        return (V)(key == this.key1 ? this.value1 : (key == this.key2 ? this.value2 : null));
    }

    @Override
    @NotNull
    public Key[] getKeys() {
        return new Key[]{this.key1, this.key2};
    }

    @Override
    public String toString() {
        return "Pair: (" + this.key1 + " -> " + this.value1 + "; " + this.key2 + " -> " + this.value2 + ")";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public Key getKey1() {
        return this.key1;
    }

    public Key getKey2() {
        return this.key2;
    }

    public Object getValue1() {
        return this.value1;
    }

    public Object getValue2() {
        return this.value2;
    }
}

