/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.PairElementsFMap;
import org.jetbrains.annotations.NotNull;

public class OneElementFMap<V>
implements KeyFMap {
    private final Key myKey;
    private final V myValue;

    public OneElementFMap(@NotNull Key key, @NotNull V value) {
        this.myKey = key;
        this.myValue = value;
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        if (this.myKey == key) {
            return new OneElementFMap<V>(key, value);
        }
        return new PairElementsFMap(this.myKey, this.myValue, key, value);
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        return key == this.myKey ? KeyFMap.EMPTY_MAP : this;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        return this.myKey == key ? (V)this.myValue : null;
    }

    @Override
    @NotNull
    public Key[] getKeys() {
        return new Key[]{this.myKey};
    }

    @Override
    public String toString() {
        return "<" + this.myKey + " -> " + this.myValue + ">";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public Key getKey() {
        return this.myKey;
    }

    public V getValue() {
        return this.myValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OneElementFMap)) {
            return false;
        }
        OneElementFMap map = (OneElementFMap)o;
        if (this.myKey != map.myKey) {
            return false;
        }
        return this.myValue.equals(map.myValue);
    }

    public int hashCode() {
        int result = this.myKey.hashCode();
        result = 31 * result + this.myValue.hashCode();
        return result;
    }
}

