/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullableDataExternalizer<T>
implements DataExternalizer<T> {
    private final DataExternalizer<T> myNotNullExternalizer;

    public NullableDataExternalizer(DataExternalizer<T> externalizer) {
        this.myNotNullExternalizer = externalizer;
    }

    @Override
    public void save(@NotNull DataOutput out, T value) throws IOException {
        if (value == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.myNotNullExternalizer.save(out, value);
        }
    }

    @Override
    @Nullable
    public T read(@NotNull DataInput in) throws IOException {
        boolean isDefined = in.readBoolean();
        if (isDefined) {
            return this.myNotNullExternalizer.read(in);
        }
        return null;
    }
}

