/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.openapi.util.Couple;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntStack;
import com.intellij.util.containers.Stack;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DFSTBuilder<Node> {
    private final Graph<Node> myGraph;
    private final TObjectIntHashMap<Node> myNodeToNNumber;
    private final Node[] myInvN;
    private Couple<Node> myBackEdge;
    private Comparator<Node> myComparator;
    private final TIntArrayList mySCCs = new TIntArrayList();
    private final TObjectIntHashMap<Node> myNodeToTNumber = new TObjectIntHashMap();
    private final Node[] myInvT;
    private final Node[] myAllNodes;

    public DFSTBuilder(@NotNull Graph<Node> graph) {
        this.myAllNodes = graph.getNodes().toArray();
        this.myGraph = graph;
        int size = graph.getNodes().size();
        this.myNodeToNNumber = new TObjectIntHashMap(size * 2, 0.5f);
        this.myInvN = new Object[size];
        this.myInvT = new Object[size];
        new Tarjan().build();
    }

    @Deprecated
    public void buildDFST() {
    }

    @NotNull
    public Comparator<Node> comparator() {
        if (this.myComparator == null) {
            final TObjectIntHashMap<Node> map = this.isAcyclic() ? this.myNodeToNNumber : this.myNodeToTNumber;
            this.myComparator = new Comparator<Node>(){

                @Override
                public int compare(@NotNull Node t, @NotNull Node t1) {
                    return map.get(t) - map.get(t1);
                }
            };
        }
        return this.myComparator;
    }

    public Couple<Node> getCircularDependency() {
        return this.myBackEdge;
    }

    public boolean isAcyclic() {
        return this.getCircularDependency() == null;
    }

    @NotNull
    public Node getNodeByNNumber(int n) {
        return this.myInvN[n];
    }

    @NotNull
    public Node getNodeByTNumber(int n) {
        return this.myInvT[n];
    }

    @NotNull
    public TIntArrayList getSCCs() {
        return this.mySCCs;
    }

    @NotNull
    public List<Node> getSortedNodes() {
        ArrayList<Node> result = new ArrayList<Node>(this.myGraph.getNodes());
        Collections.sort(result, this.comparator());
        return result;
    }

    private class Tarjan {
        private final int[] lowLink;
        private final int[] index;
        private final IntStack nodesOnStack;
        private final boolean[] isOnStack;
        private final Stack<com.intellij.util.graph.DFSTBuilder$Tarjan.Frame> frames;
        private final TObjectIntHashMap<Node> nodeIndex;
        private int dfsIndex;
        private int sccsSizeCombined;
        private final TIntArrayList topo;

        private Tarjan() {
            this.lowLink = new int[DFSTBuilder.this.myInvN.length];
            this.index = new int[DFSTBuilder.this.myInvN.length];
            this.nodesOnStack = new IntStack();
            this.isOnStack = new boolean[this.index.length];
            this.frames = new Stack();
            this.nodeIndex = new TObjectIntHashMap();
            this.topo = new TIntArrayList(this.index.length);
        }

        private void build() {
            int i;
            Arrays.fill(this.index, -1);
            for (i = 0; i < DFSTBuilder.this.myAllNodes.length; ++i) {
                Object node = DFSTBuilder.this.myAllNodes[i];
                this.nodeIndex.put(node, i);
            }
            for (i = 0; i < this.index.length; ++i) {
                if (this.index[i] != -1) continue;
                this.frames.push((com.intellij.util.graph.DFSTBuilder$Tarjan.Frame)new Frame(i));
                ArrayList sccs = new ArrayList();
                this.strongConnect(sccs);
                for (List list : sccs) {
                    int sccSize = list.size();
                    DFSTBuilder.this.mySCCs.add(sccSize);
                    int sccBase = this.index.length - this.sccsSizeCombined - sccSize;
                    Object rootNode = DFSTBuilder.this.myAllNodes[i];
                    int rIndex = list.indexOf(rootNode);
                    if (rIndex != -1) {
                        ContainerUtil.swapElements(list, rIndex, 0);
                    }
                    for (int j = 0; j < list.size(); ++j) {
                        Object sccNode = list.get(j);
                        int tIndex = sccBase + j;
                        ((DFSTBuilder)DFSTBuilder.this).myInvT[tIndex] = sccNode;
                        DFSTBuilder.this.myNodeToTNumber.put(sccNode, tIndex);
                    }
                    this.sccsSizeCombined += sccSize;
                }
            }
            for (i = 0; i < this.topo.size(); ++i) {
                int nodeI = this.topo.get(i);
                Object node = DFSTBuilder.this.myAllNodes[nodeI];
                DFSTBuilder.this.myNodeToNNumber.put(node, this.index.length - 1 - i);
                ((DFSTBuilder)DFSTBuilder.this).myInvN[this.index.length - 1 - i] = node;
            }
            DFSTBuilder.this.mySCCs.reverse();
        }

        private void strongConnect(@NotNull List<List<Node>> sccs) {
            int successor = -1;
            block0: while (!this.frames.isEmpty()) {
                int pushedI;
                Frame pair = (Frame)this.frames.peek();
                int i = pair.nodeI;
                if (this.index[i] == -1) {
                    this.index[i] = this.dfsIndex;
                    this.lowLink[i] = this.dfsIndex++;
                    this.nodesOnStack.push(i);
                    this.isOnStack[i] = true;
                }
                if (ArrayUtil.indexOf(pair.out, successor) != -1) {
                    this.lowLink[i] = Math.min(this.lowLink[i], this.lowLink[successor]);
                }
                successor = i;
                while (pair.nextUnexploredIndex < pair.out.length) {
                    int nextI = pair.out[pair.nextUnexploredIndex++];
                    if (this.index[nextI] == -1) {
                        this.frames.push((com.intellij.util.graph.DFSTBuilder$Tarjan.Frame)new Frame(nextI));
                        continue block0;
                    }
                    if (!this.isOnStack[nextI]) continue;
                    this.lowLink[i] = Math.min(this.lowLink[i], this.index[nextI]);
                    if (DFSTBuilder.this.myBackEdge != null) continue;
                    DFSTBuilder.this.myBackEdge = Couple.of(DFSTBuilder.this.myAllNodes[nextI], DFSTBuilder.this.myAllNodes[i]);
                }
                this.frames.pop();
                this.topo.add(i);
                if (this.lowLink[i] != this.index[i]) continue;
                ArrayList<Object> scc = new ArrayList<Object>();
                do {
                    pushedI = this.nodesOnStack.pop();
                    Object pushed = DFSTBuilder.this.myAllNodes[pushedI];
                    this.isOnStack[pushedI] = false;
                    scc.add(pushed);
                } while (pushedI != i);
                sccs.add(scc);
            }
        }

        private class Frame {
            private final int nodeI;
            private final int[] out;
            private int nextUnexploredIndex;

            public Frame(int nodeI) {
                this.nodeI = nodeI;
                Iterator<Object> outNodes = DFSTBuilder.this.myGraph.getOut(DFSTBuilder.this.myAllNodes[nodeI]);
                TIntArrayList list = new TIntArrayList();
                while (outNodes.hasNext()) {
                    Object node = outNodes.next();
                    list.add(Tarjan.this.nodeIndex.get(node));
                }
                this.out = list.toNativeArray();
            }

            public String toString() {
                StringBuilder o = new StringBuilder();
                for (int id : this.out) {
                    o.append(DFSTBuilder.this.myAllNodes[id] + ", ");
                }
                return DFSTBuilder.this.myAllNodes[this.nodeI] + " -> [" + o + "]";
            }
        }
    }
}

