/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.execution;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class ParametersListUtil {
    public static final Function<String, List<String>> DEFAULT_LINE_PARSER = new Function<String, List<String>>(){

        @Override
        public List<String> fun(String text) {
            return ParametersListUtil.parse(text, true);
        }
    };
    public static final Function<List<String>, String> DEFAULT_LINE_JOINER = new Function<List<String>, String>(){

        @Override
        public String fun(List<String> strings) {
            return StringUtil.join(strings, " ");
        }
    };
    public static final Function<String, List<String>> COLON_LINE_PARSER = new Function<String, List<String>>(){

        @Override
        public List<String> fun(String text) {
            ArrayList<String> result = ContainerUtilRt.newArrayList();
            StringTokenizer tokenizer = new StringTokenizer(text, ";", false);
            while (tokenizer.hasMoreTokens()) {
                result.add(tokenizer.nextToken());
            }
            return result;
        }
    };
    public static final Function<List<String>, String> COLON_LINE_JOINER = new Function<List<String>, String>(){

        @Override
        public String fun(List<String> strings) {
            return StringUtil.join(strings, ";");
        }
    };

    @NotNull
    public static String join(@NotNull List<String> parameters) {
        return ParametersListUtil.encode(parameters);
    }

    @NotNull
    public static String join(String ... parameters) {
        return ParametersListUtil.encode(Arrays.asList(parameters));
    }

    @NotNull
    public static String[] parseToArray(@NotNull String string) {
        List<String> params = ParametersListUtil.parse(string);
        return ArrayUtil.toStringArray(params);
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString) {
        return ParametersListUtil.parse(parameterString, false);
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString, boolean keepQuotes) {
        parameterString = parameterString.trim();
        ArrayList<String> params = ContainerUtilRt.newArrayList();
        StringBuilder token = new StringBuilder(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        boolean nonEmpty = false;
        for (int i = 0; i < parameterString.length(); ++i) {
            char ch = parameterString.charAt(i);
            if (ch == '\"') {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    nonEmpty = true;
                    if (!keepQuotes) continue;
                }
                escapedQuote = false;
            } else if (Character.isWhitespace(ch)) {
                if (!inQuotes) {
                    if (token.length() <= 0 && !nonEmpty) continue;
                    params.add(token.toString());
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i < parameterString.length() - 1 && parameterString.charAt(i + 1) == '\"') {
                escapedQuote = true;
                if (!keepQuotes) continue;
            }
            token.append(ch);
        }
        if (token.length() > 0 || nonEmpty) {
            params.add(token.toString());
        }
        return params;
    }

    @NotNull
    private static String encode(@NotNull List<String> parameters) {
        StringBuilder buffer = new StringBuilder();
        for (String parameter : parameters) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(ParametersListUtil.encode(parameter));
        }
        return buffer.toString();
    }

    @NotNull
    private static String encode(@NotNull String parameter) {
        StringBuilder builder = new StringBuilder();
        builder.append(parameter);
        StringUtil.escapeQuotes(builder);
        if (builder.length() == 0 || StringUtil.indexOf((CharSequence)builder, ' ') >= 0 || StringUtil.indexOf((CharSequence)builder, '|') >= 0) {
            StringUtil.quote(builder);
        }
        return builder.toString();
    }
}

