/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.TreeTraversal;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredTraverserBase<T, Self extends FilteredTraverserBase<T, Self>>
implements Iterable<T> {
    protected final Meta<T> meta;
    protected final Function<T, ? extends Iterable<? extends T>> tree;

    protected FilteredTraverserBase(@Nullable Meta<T> meta, Function<T, ? extends Iterable<? extends T>> tree) {
        this.tree = tree;
        this.meta = meta == null ? Meta.empty() : meta;
    }

    @NotNull
    public T getRoot() {
        return this.meta.roots.iterator().next();
    }

    @NotNull
    public Iterable<? extends T> getRoots() {
        return this.meta.roots;
    }

    @Override
    public Iterator<T> iterator() {
        return this.traverse().iterator();
    }

    @NotNull
    protected abstract Self newInstance(Meta<T> var1);

    @NotNull
    public JBIterable<T> traverse(TreeTraversal traversal) {
        Function adjusted = new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> fun(T t) {
                return FilteredTraverserBase.this.children(t);
            }
        };
        return traversal.traversal(this.getRoots(), adjusted).filter(this.meta.filter.AND());
    }

    @NotNull
    public JBIterable<T> traverse() {
        return this.traverse(this.meta.traversal);
    }

    @NotNull
    public final JBIterable<T> preOrderDfsTraversal() {
        return this.traverse(TreeTraversal.PRE_ORDER_DFS);
    }

    @NotNull
    public final JBIterable<T> postOrderDfsTraversal() {
        return this.traverse(TreeTraversal.POST_ORDER_DFS);
    }

    @NotNull
    public final JBIterable<T> bfsTraversal() {
        return this.traverse(TreeTraversal.PLAIN_BFS);
    }

    @NotNull
    public final JBIterable<T> tracingBfsTraversal() {
        return this.traverse(TreeTraversal.TRACING_BFS);
    }

    @NotNull
    public Self reset() {
        return this.newInstance(this.meta.reset());
    }

    @NotNull
    public Self withRoot(@Nullable T root) {
        return this.newInstance(this.meta.withRoots(ContainerUtil.createMaybeSingletonList(root)));
    }

    @NotNull
    public Self withRoots(@NotNull Iterable<? extends T> roots) {
        return this.newInstance(this.meta.withRoots(roots));
    }

    @NotNull
    public Self withTraversal(TreeTraversal type) {
        return this.newInstance(this.meta.withTraversal(type));
    }

    @NotNull
    public Self expand(@NotNull Condition<? super T> c) {
        return this.newInstance(this.meta.expand(c));
    }

    @NotNull
    public Self regard(@NotNull Condition<? super T> c) {
        return this.newInstance(this.meta.regard(c));
    }

    @NotNull
    public Self expandAndFilter(Condition<? super T> c) {
        return this.newInstance(this.meta.expand(c).filter(c));
    }

    @NotNull
    public Self expandAndSkip(Condition<? super T> c) {
        return this.newInstance(this.meta.expand(c).filter(Conditions.not(c)));
    }

    @NotNull
    public Self filter(@NotNull Condition<? super T> c) {
        return this.newInstance(this.meta.filter(c));
    }

    @NotNull
    public <C> JBIterable<C> filter(@NotNull Class<C> type) {
        return this.traverse().filter(type);
    }

    @NotNull
    public Self forceIgnore(@NotNull Condition<? super T> c) {
        return this.newInstance(this.meta.forceIgnore(c));
    }

    @NotNull
    public Self forceDisregard(@NotNull Condition<? super T> c) {
        return this.newInstance(this.meta.forceDisregard(c));
    }

    @NotNull
    public JBIterable<T> children(@Nullable T node) {
        if (node == null || this.isAlwaysLeaf(node)) {
            return JBIterable.empty();
        }
        if (this.meta.regard.next == null && this.meta.forceDisregard.next == null) {
            return JBIterable.from(this.tree.fun(node)).filter(Conditions.not(this.meta.forceIgnore.OR()));
        }
        return TreeTraversal.GUIDED_TRAVERSAL.traversal(node, this.tree).intercept(this.meta.createChildrenGuide(node));
    }

    protected boolean isAlwaysLeaf(@NotNull T node) {
        return !this.meta.expand.valueAnd(node);
    }

    @NotNull
    public List<T> toList() {
        return this.traverse().toList();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "traversal=" + this.meta.traversal + '}';
    }

    private static class Cond<T> {
        static final Cond TRUE = new Cond<Object>(Conditions.TRUE, null);
        static final Cond FALSE = new Cond<Object>(Conditions.FALSE, null);
        final Condition<? super T> impl;
        final Cond<T> next;

        Cond(Condition<? super T> impl, Cond<T> next) {
            this.impl = impl;
            this.next = next;
        }

        Cond<T> append(Condition<? super T> impl) {
            return new Cond<T>(impl, this);
        }

        private boolean valueAnd(T t) {
            Cond<T> c = this;
            while (c != null) {
                if (!c.impl.value(t)) {
                    return false;
                }
                c = c.next;
            }
            return true;
        }

        private boolean valueOr(T t) {
            Cond<T> c = this;
            while (c != null) {
                if (c.impl.value(t)) {
                    return true;
                }
                c = c.next;
            }
            return false;
        }

        Condition<? super T> OR() {
            return new Condition<T>(){

                @Override
                public boolean value(T t) {
                    return Cond.this.valueOr(t);
                }
            };
        }

        Condition<? super T> AND() {
            return new Condition<T>(){

                @Override
                public boolean value(T t) {
                    return Cond.this.valueAnd(t);
                }
            };
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Cond{");
            Cond<T> c = this;
            while (c != null) {
                sb.append(JBIterator.toShortString(c.impl));
                if (c.next != null) {
                    sb.append(", ");
                }
                c = c.next;
            }
            return sb.append("}").toString();
        }
    }

    protected static class Meta<T> {
        final Iterable<? extends T> roots;
        final TreeTraversal traversal;
        final Cond<T> expand;
        final Cond<T> regard;
        final Cond<T> filter;
        final Cond<T> forceIgnore;
        final Cond<T> forceDisregard;
        private static final Meta<?> EMPTY = new Meta(JBIterable.empty(), TreeTraversal.PRE_ORDER_DFS, Cond.TRUE, Cond.TRUE, Cond.TRUE, Cond.FALSE, Cond.FALSE);

        public Meta(@NotNull Iterable<? extends T> roots, @NotNull TreeTraversal traversal, @NotNull Cond<T> expand, @NotNull Cond<T> regard, @NotNull Cond<T> filter, @NotNull Cond<T> forceIgnore, @NotNull Cond<T> forceDisregard) {
            this.roots = roots;
            this.traversal = traversal;
            this.expand = expand;
            this.regard = regard;
            this.filter = filter;
            this.forceIgnore = forceIgnore;
            this.forceDisregard = forceDisregard;
        }

        public Meta<T> reset() {
            return new Meta<T>(this.roots, TreeTraversal.PRE_ORDER_DFS, Cond.TRUE, Cond.TRUE, Cond.TRUE, this.forceIgnore, this.forceDisregard);
        }

        public Meta<T> withRoots(@NotNull Iterable<? extends T> roots) {
            return new Meta<T>(roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard);
        }

        public Meta<T> withTraversal(TreeTraversal traversal) {
            return new Meta<T>(this.roots, traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard);
        }

        public Meta<T> expand(@NotNull Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand.append(c), this.regard, this.filter, this.forceIgnore, this.forceDisregard);
        }

        public Meta<T> regard(@NotNull Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard.append(c), this.filter, this.forceIgnore, this.forceDisregard);
        }

        public Meta<T> filter(@NotNull Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter.append(c), this.forceIgnore, this.forceDisregard);
        }

        public Meta<T> forceIgnore(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore.append(c), this.forceDisregard);
        }

        public Meta<T> forceDisregard(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard.append(c));
        }

        Function.Mono<TreeTraversal.GuidedIt<T>> createChildrenGuide(T parent) {
            final Condition<T> expand = this.buildExpandConditionForChildren(parent);
            class G
            implements Consumer<TreeTraversal.GuidedIt<T>>,
            Function.Mono<TreeTraversal.GuidedIt<T>> {
                G() {
                }

                @Override
                public TreeTraversal.GuidedIt<T> fun(TreeTraversal.GuidedIt<T> it) {
                    return it.setGuide(this);
                }

                @Override
                public void consume(TreeTraversal.GuidedIt<T> it) {
                    Meta.this.doPerformChildrenGuidance(it, expand);
                }
            }
            return new G();
        }

        private void doPerformChildrenGuidance(TreeTraversal.GuidedIt<T> it, Condition<? super T> expand) {
            if (it.curChild == null) {
                return;
            }
            if (((Cond)this.forceIgnore).valueOr(it.curChild)) {
                return;
            }
            if (it.curParent == null || expand.value(it.curChild)) {
                it.queueNext(it.curChild);
            } else {
                it.result(it.curChild);
            }
        }

        private Condition<? super T> buildExpandConditionForChildren(T parent) {
            Cond copy = null;
            boolean invert = true;
            Cond<T> c = this.regard;
            while (c != null) {
                Condition impl = JBIterable.Stateful.copy(c.impl);
                if (impl != (invert ? Condition.TRUE : Condition.FALSE)) {
                    copy = new Cond(invert ? Conditions.not(impl) : impl, copy);
                    if (impl instanceof EdgeFilter) {
                        ((EdgeFilter)impl).edgeSource = parent;
                    }
                }
                if (c.next == null) {
                    c = invert ? this.forceDisregard : null;
                    invert = false;
                    continue;
                }
                c = c.next;
            }
            return copy == null ? Condition.FALSE : copy.OR();
        }

        public static <T> Meta<T> empty() {
            return EMPTY;
        }
    }

    public static abstract class EdgeFilter<T>
    extends JBIterable.StatefulFilter<T> {
        protected T edgeSource;
    }
}

