/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.Patches;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class BoundedTaskExecutor
extends AbstractExecutorService {
    private volatile boolean myShutdown;
    private final Executor myBackendExecutor;
    private final int myMaxTasks;
    private final AtomicLong myStatus = new AtomicLong();
    private final BlockingQueue<Runnable> myTaskQueue = new LinkedBlockingQueue<Runnable>();
    static final /* synthetic */ boolean $assertionsDisabled;

    public BoundedTaskExecutor(@NotNull Executor backendExecutor, int maxSimultaneousTasks) {
        this.myBackendExecutor = backendExecutor;
        if (maxSimultaneousTasks < 1) {
            throw new IllegalArgumentException("maxSimultaneousTasks must be >=1 but got: " + maxSimultaneousTasks);
        }
        if (backendExecutor instanceof BoundedTaskExecutor) {
            throw new IllegalArgumentException("backendExecutor is already BoundedTaskExecutor: " + backendExecutor);
        }
        this.myMaxTasks = maxSimultaneousTasks;
    }

    public BoundedTaskExecutor(@NotNull Executor backendExecutor, int maxSimultaneousTasks, @NotNull Disposable parent) {
        this(backendExecutor, maxSimultaneousTasks);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                BoundedTaskExecutor.this.shutdownNow();
            }
        });
    }

    static Object info(Object task) {
        if (task instanceof FutureTask) {
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Callable.class, "callable"), task.getClass());
        }
        if (task instanceof Callable && task.getClass().getName().equals("java.util.concurrent.Executors$RunnableAdapter")) {
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Runnable.class, "task"), task.getClass());
        }
        return task;
    }

    @Override
    public void shutdown() {
        if (this.myShutdown) {
            throw new IllegalStateException("Already shutdown");
        }
        this.myShutdown = true;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return this.clearAndCancelAll();
    }

    @Override
    public boolean isShutdown() {
        return this.myShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.myShutdown;
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        if (!this.isShutdown()) {
            throw new IllegalStateException("you must call shutdown() first");
        }
        return true;
    }

    @Override
    public void execute(@NotNull Runnable task) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Already shutdown");
        }
        long status = this.incrementCounterAndTimestamp();
        if (this.tryToExecute(status, task)) {
            return;
        }
        if (!this.myTaskQueue.offer(task)) {
            throw new RejectedExecutionException();
        }
        this.pollAndExecute(status);
    }

    private long incrementCounterAndTimestamp() {
        long newStatus;
        long status;
        while (!this.myStatus.compareAndSet(status = this.myStatus.get(), newStatus = status + 1L + 0x100000000L & Long.MAX_VALUE)) {
        }
        return newStatus;
    }

    private void pollAndExecute(long status) {
        while (true) {
            Runnable next;
            int inProgress = (int)status;
            if (!$assertionsDisabled && inProgress <= 0) {
                throw new AssertionError(inProgress);
            }
            if (inProgress <= this.myMaxTasks && (next = (Runnable)this.myTaskQueue.poll()) != null) {
                this.tryToExecute(status, next);
                break;
            }
            if (this.myStatus.compareAndSet(status, status - 1L)) break;
            status = this.myStatus.get();
        }
    }

    private boolean tryToExecute(long status, @NotNull Runnable task) {
        int inProgress = (int)status;
        if (!$assertionsDisabled && inProgress <= 0) {
            throw new AssertionError(inProgress);
        }
        if (inProgress <= this.myMaxTasks) {
            try {
                this.myBackendExecutor.execute(this.wrap(task));
            }
            catch (Error e) {
                this.myStatus.decrementAndGet();
                throw e;
            }
            catch (RuntimeException e) {
                this.myStatus.decrementAndGet();
                throw e;
            }
            return true;
        }
        return false;
    }

    @NotNull
    private Runnable wrap(final @NotNull Runnable task) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                finally {
                    BoundedTaskExecutor.this.pollAndExecute(BoundedTaskExecutor.this.myStatus.get());
                }
            }

            public String toString() {
                return String.valueOf(BoundedTaskExecutor.info(task));
            }
        };
    }

    public void waitAllTasksExecuted(int timeout, @NotNull TimeUnit unit) throws ExecutionException, InterruptedException {
        final CountDownLatch started = new CountDownLatch(this.myMaxTasks);
        final CountDownLatch readyToFinish = new CountDownLatch(1);
        List<Future> futures = ContainerUtil.map(Collections.nCopies(this.myMaxTasks, null), new Function<Object, Future>(){

            @Override
            public Future fun(Object o) {
                return BoundedTaskExecutor.this.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            started.countDown();
                            readyToFinish.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        });
        try {
            if (!started.await(timeout, unit)) {
                throw new RuntimeException("Interrupted by timeout. " + this + "; Thread dump:\n" + ThreadDumper.dumpThreadsToString());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            readyToFinish.countDown();
        }
        for (Future future : futures) {
            future.get();
        }
    }

    @NotNull
    public List<Runnable> clearAndCancelAll() {
        ArrayList<Runnable> queued = new ArrayList<Runnable>();
        this.myTaskQueue.drainTo(queued);
        for (Runnable task : queued) {
            if (!(task instanceof FutureTask)) continue;
            ((FutureTask)task).cancel(false);
        }
        return queued;
    }

    public String toString() {
        return "BoundedExecutor(" + this.myMaxTasks + ") " + (this.isShutdown() ? "SHUTDOWN " : "") + "inProgress: " + (int)this.myStatus.get() + "; " + this.myTaskQueue.size() + " tasks in queue: [" + ContainerUtil.map(this.myTaskQueue, new Function<Runnable, Object>(){

            @Override
            public Object fun(Runnable runnable) {
                return BoundedTaskExecutor.info(runnable);
            }
        }) + "]";
    }

    static {
        boolean bl = $assertionsDisabled = !BoundedTaskExecutor.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Patches.USE_REFLECTION_TO_ACCESS_JDK8) {
            throw new AssertionError();
        }
    }
}

