/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.containers.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class BlockingSet<T> {
    private final Set<T> set = new HashSet<T>();
    private final Condition unlock;
    private final Lock lock = new ReentrantLock();

    public BlockingSet() {
        this.unlock = this.lock.newCondition();
    }

    public void put(@NotNull T key) {
        this.lock.lock();
        try {
            while (this.set.contains(key)) {
                this.unlock.awaitUninterruptibly();
            }
            this.set.add(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(@NotNull T key) throws IllegalStateException {
        this.lock.lock();
        try {
            if (!this.set.contains(key)) {
                throw new IllegalStateException();
            }
            this.set.remove(key);
            this.unlock.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static <T> BlockingSet<T> newInstance() {
        return new BlockingSet<T>();
    }
}

