/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class AtomicFieldUpdater<T, V> {
    private static final Unsafe unsafe = ReflectionUtil.getStaticFieldValue(Unsafe.class, Unsafe.class, "theUnsafe");
    private final long offset;

    @NotNull
    public static Unsafe getUnsafe() {
        return unsafe;
    }

    @NotNull
    public static <T, V> AtomicFieldUpdater<T, V> forFieldOfType(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        return new AtomicFieldUpdater<T, V>(ownerClass, fieldType);
    }

    @NotNull
    public static <T> AtomicFieldUpdater<T, Long> forLongFieldIn(@NotNull Class<T> ownerClass) {
        return new AtomicFieldUpdater<T, Long>(ownerClass, Long.TYPE);
    }

    @NotNull
    public static <T> AtomicFieldUpdater<T, Integer> forIntFieldIn(@NotNull Class<T> ownerClass) {
        return new AtomicFieldUpdater<T, Integer>(ownerClass, Integer.TYPE);
    }

    private AtomicFieldUpdater(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        Field found = AtomicFieldUpdater.getTheOnlyVolatileFieldOfClass(ownerClass, fieldType);
        this.offset = unsafe.objectFieldOffset(found);
    }

    @NotNull
    private static <T, V> Field getTheOnlyVolatileFieldOfClass(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        Field[] declaredFields = ownerClass.getDeclaredFields();
        Field found = null;
        for (Field field : declaredFields) {
            if ((field.getModifiers() & 0x18) != 0 || !fieldType.isAssignableFrom(field.getType())) continue;
            if (found == null) {
                found = field;
                continue;
            }
            throw new IllegalArgumentException("Two fields of " + fieldType + " found in the " + ownerClass + ": " + found.getName() + " and " + field.getName());
        }
        if (found == null) {
            throw new IllegalArgumentException("No (non-static, non-final) field of " + fieldType + " found in the " + ownerClass);
        }
        found.setAccessible(true);
        if ((found.getModifiers() & 0x40) == 0) {
            throw new IllegalArgumentException("Field " + found + " in the " + ownerClass + " must be volatile");
        }
        return found;
    }

    public boolean compareAndSet(@NotNull T owner, V expected, V newValue) {
        return unsafe.compareAndSwapObject(owner, this.offset, expected, newValue);
    }

    public boolean compareAndSetLong(@NotNull T owner, long expected, long newValue) {
        return unsafe.compareAndSwapLong(owner, this.offset, expected, newValue);
    }

    public boolean compareAndSetInt(@NotNull T owner, int expected, int newValue) {
        return unsafe.compareAndSwapInt(owner, this.offset, expected, newValue);
    }

    public void set(@NotNull T owner, V newValue) {
        unsafe.putObjectVolatile(owner, this.offset, newValue);
    }

    public V get(@NotNull T owner) {
        return (V)unsafe.getObjectVolatile(owner, this.offset);
    }

    static {
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the " + Unsafe.class);
        }
    }
}

