/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DeprecatedDuplicatesIconPathPatcher;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RetrievableIcon;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.IconLoader");
    public static boolean STRICT = false;
    private static boolean USE_DARK_ICONS = UIUtil.isUnderDarcula();
    private static float SCALE = JBUI.scale(1.0f);
    private static ImageFilter IMAGE_FILTER;
    private static final ConcurrentMap<URL, CachedImageIcon> ourIconsCache;
    private static final Map<Icon, Icon> ourIcon2DisabledIcon;
    @NonNls
    private static final List<IconPathPatcher> ourPatchers;
    private static final ImageIcon EMPTY_ICON;
    private static boolean ourIsActivated;

    private IconLoader() {
    }

    public static void installPathPatcher(IconPathPatcher patcher) {
        ourPatchers.add(patcher);
        IconLoader.clearCache();
    }

    @Deprecated
    public static Icon getIcon(@NotNull Image image) {
        return new JBImageIcon(image);
    }

    public static void setUseDarkIcons(boolean useDarkIcons) {
        USE_DARK_ICONS = useDarkIcons;
        IconLoader.clearCache();
    }

    public static void setScale(float scale) {
        if (scale != SCALE) {
            SCALE = scale;
            IconLoader.clearCache();
        }
    }

    public static void setFilter(ImageFilter filter) {
        if (!Registry.is("color.blindness.icon.filter")) {
            filter = null;
        }
        if (IMAGE_FILTER != filter) {
            IMAGE_FILTER = filter;
            IconLoader.clearCache();
        }
    }

    private static void clearCache() {
        ourIconsCache.clear();
        ourIcon2DisabledIcon.clear();
    }

    @NotNull
    public static Icon getIcon(@NonNls @NotNull String path) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        assert (callerClass != null) : path;
        return IconLoader.getIcon(path, callerClass);
    }

    @Nullable
    private static Icon getReflectiveIcon(@NotNull String path, ClassLoader classLoader) {
        try {
            String pckg = path.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.";
            Class<?> cur = Class.forName(pckg + path.substring(0, path.lastIndexOf(46)).replace('.', '$'), true, classLoader);
            Field field = cur.getField(path.substring(path.lastIndexOf(46) + 1));
            return (Icon)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return IconLoader.findIcon(path, callerClass);
    }

    @NotNull
    public static Icon getIcon(@NotNull String path, @NotNull Class aClass) {
        Icon icon = IconLoader.findIcon(path, aClass);
        if (icon == null) {
            LOG.error("Icon cannot be found in '" + path + "', aClass='" + aClass + "'");
        }
        return icon;
    }

    public static void activate() {
        ourIsActivated = true;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass) {
        return IconLoader.findIcon(path, aClass, false);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass, boolean computeNow) {
        return IconLoader.findIcon(path, aClass, computeNow, STRICT);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass, boolean computeNow, boolean strict) {
        String originalPath = path;
        if (IconLoader.isReflectivePath(path = IconLoader.patchPath(path))) {
            return IconLoader.getReflectiveIcon(path, aClass.getClassLoader());
        }
        URL myURL = aClass.getResource(path);
        if (myURL == null) {
            if (strict) {
                throw new RuntimeException("Can't find icon in '" + path + "' near " + aClass);
            }
            return null;
        }
        Icon icon = IconLoader.findIcon(myURL);
        if (icon instanceof CachedImageIcon) {
            ((CachedImageIcon)icon).myOriginalPath = originalPath;
            ((CachedImageIcon)icon).myClassLoader = aClass.getClassLoader();
        }
        return icon;
    }

    private static String patchPath(@NotNull String path) {
        for (IconPathPatcher patcher : ourPatchers) {
            String newPath = patcher.patchPath(path);
            if (newPath == null) continue;
            path = newPath;
        }
        return path;
    }

    private static boolean isReflectivePath(@NotNull String path) {
        List<String> paths = StringUtil.split(path, ".");
        return paths.size() > 1 && paths.get(0).endsWith("Icons");
    }

    @Nullable
    public static Icon findIcon(URL url) {
        return IconLoader.findIcon(url, true);
    }

    @Nullable
    public static Icon findIcon(URL url, boolean useCache) {
        if (url == null) {
            return null;
        }
        CachedImageIcon icon = (CachedImageIcon)ourIconsCache.get(url);
        if (icon == null) {
            icon = new CachedImageIcon(url);
            if (useCache) {
                icon = ConcurrencyUtil.cacheOrGet(ourIconsCache, url, icon);
            }
        }
        return icon;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        String originalPath = path;
        if (IconLoader.isReflectivePath(path = IconLoader.patchPath(path))) {
            return IconLoader.getReflectiveIcon(path, classLoader);
        }
        if (!StringUtil.startsWithChar(path, '/')) {
            return null;
        }
        URL url = classLoader.getResource(path.substring(1));
        Icon icon = IconLoader.findIcon(url);
        if (icon instanceof CachedImageIcon) {
            ((CachedImageIcon)icon).myOriginalPath = originalPath;
            ((CachedImageIcon)icon).myClassLoader = classLoader;
        }
        return icon;
    }

    @Nullable
    private static ImageIcon checkIcon(Image image, @NotNull URL url) {
        if (image == null || image.getHeight(LabelHolder.ourFakeComponent) < 1) {
            return null;
        }
        Icon icon = IconLoader.getIcon(image);
        if (icon != null && !IconLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + url);
            return EMPTY_ICON;
        }
        assert (icon instanceof ImageIcon);
        return (ImageIcon)icon;
    }

    public static boolean isGoodSize(@NotNull Icon icon) {
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    @Nullable
    public static Icon getDisabledIcon(Icon icon) {
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon == null) {
            return null;
        }
        Icon disabledIcon = ourIcon2DisabledIcon.get(icon);
        if (disabledIcon == null) {
            if (!IconLoader.isGoodSize(icon)) {
                return EMPTY_ICON;
            }
            int scale = UIUtil.isRetina() ? 2 : 1;
            BufferedImage image = new BufferedImage(scale * icon.getIconWidth(), scale * icon.getIconHeight(), 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setColor(UIUtil.TRANSPARENT_COLOR);
            graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
            graphics.scale(scale, scale);
            icon.paintIcon(LabelHolder.ourFakeComponent, graphics, 0, 0);
            graphics.dispose();
            Image img = ImageUtil.filter(image, UIUtil.getGrayFilter());
            if (UIUtil.isRetina()) {
                img = RetinaImage.createFrom(img);
            }
            disabledIcon = new JBImageIcon(img);
            ourIcon2DisabledIcon.put(icon, disabledIcon);
        }
        return disabledIcon;
    }

    public static Icon getTransparentIcon(@NotNull Icon icon) {
        return IconLoader.getTransparentIcon(icon, 0.5f);
    }

    public static Icon getTransparentIcon(final @NotNull Icon icon, final float alpha) {
        return new RetrievableIcon(){

            @Override
            @Nullable
            public Icon retrieveIcon() {
                return icon;
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(10, alpha));
                icon.paintIcon(c, g2, x, y);
                g2.setComposite(saveComposite);
            }
        };
    }

    @NotNull
    public static Icon getIconSnapshot(@NotNull Icon icon) {
        if (icon instanceof CachedImageIcon) {
            return ((CachedImageIcon)icon).getRealIcon();
        }
        return icon;
    }

    static {
        ourIconsCache = ContainerUtil.newConcurrentMap(100, 0.9f, 2);
        ourIcon2DisabledIcon = new WeakHashMap<Icon, Icon>(200);
        ourPatchers = new ArrayList<IconPathPatcher>(2);
        IconLoader.installPathPatcher(new DeprecatedDuplicatesIconPathPatcher());
        EMPTY_ICON = new ImageIcon(UIUtil.createImage(1, 1, 5)){

            @Override
            @NonNls
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
        ourIsActivated = false;
    }

    private static class LabelHolder {
        private static final JComponent ourFakeComponent = new JLabel();

        private LabelHolder() {
        }
    }

    public static abstract class LazyIcon
    implements Icon {
        private boolean myWasComputed;
        private Icon myIcon;
        private boolean isDarkVariant = IconLoader.access$600();
        private float scale = IconLoader.access$700();
        private int numberOfPatchers = IconLoader.access$400().size();
        private ImageFilter filter = IconLoader.access$800();

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon icon = this.getOrComputeIcon();
            if (icon != null) {
                icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconWidth() : 0;
        }

        @Override
        public int getIconHeight() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconHeight() : 0;
        }

        protected final synchronized Icon getOrComputeIcon() {
            if (!this.myWasComputed || this.isDarkVariant != USE_DARK_ICONS || this.scale != SCALE || this.filter != IMAGE_FILTER || this.numberOfPatchers != ourPatchers.size()) {
                this.isDarkVariant = USE_DARK_ICONS;
                this.scale = SCALE;
                this.filter = IMAGE_FILTER;
                this.myWasComputed = true;
                this.numberOfPatchers = ourPatchers.size();
                this.myIcon = this.compute();
            }
            return this.myIcon;
        }

        public final void load() {
            this.getIconWidth();
        }

        protected abstract Icon compute();
    }

    private static final class CachedImageIcon
    implements ScalableIcon {
        private volatile Object myRealIcon;
        private String myOriginalPath;
        private ClassLoader myClassLoader;
        @NotNull
        private URL myUrl;
        private volatile boolean dark;
        private volatile float scale;
        private volatile int numberOfPatchers = IconLoader.access$400().size();
        private volatile ImageFilter filter;
        private final MyScaledIconsCache myScaledIconsCache = new MyScaledIconsCache();

        public CachedImageIcon(@NotNull URL url) {
            this.myUrl = url;
            this.dark = USE_DARK_ICONS;
            this.scale = SCALE;
            this.filter = IMAGE_FILTER;
        }

        @NotNull
        private synchronized ImageIcon getRealIcon() {
            ImageIcon icon;
            Object realIcon;
            if (IconLoader.isLoaderDisabled() && (this.myRealIcon == null || this.dark != USE_DARK_ICONS || this.scale != SCALE || this.filter != IMAGE_FILTER || this.numberOfPatchers != ourPatchers.size())) {
                return EMPTY_ICON;
            }
            if (!this.isValid()) {
                this.myRealIcon = null;
                this.dark = USE_DARK_ICONS;
                this.scale = SCALE;
                this.filter = IMAGE_FILTER;
                this.myScaledIconsCache.clear();
                if (this.numberOfPatchers != ourPatchers.size()) {
                    URL url;
                    String path;
                    this.numberOfPatchers = ourPatchers.size();
                    String string = path = this.myOriginalPath == null ? null : IconLoader.patchPath(this.myOriginalPath);
                    if (this.myClassLoader != null && path != null && path.startsWith("/") && (url = this.myClassLoader.getResource(path = path.substring(1))) != null) {
                        this.myUrl = url;
                    }
                }
            }
            if ((realIcon = this.myRealIcon) instanceof Icon) {
                return (ImageIcon)realIcon;
            }
            if (realIcon instanceof Reference && (icon = (ImageIcon)((Reference)realIcon).get()) != null) {
                return icon;
            }
            Image image = ImageLoader.loadFromUrl(this.myUrl, true, this.filter);
            icon = IconLoader.checkIcon(image, this.myUrl);
            if (icon != null) {
                realIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference<ImageIcon>(icon);
                this.myRealIcon = realIcon;
            }
            return icon == null ? EMPTY_ICON : icon;
        }

        private boolean isValid() {
            return this.dark == USE_DARK_ICONS && this.scale == SCALE && this.filter == IMAGE_FILTER && this.numberOfPatchers == ourPatchers.size();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getRealIcon().paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon().getIconHeight();
        }

        public String toString() {
            return this.myUrl.toString();
        }

        @Override
        public Icon scale(float scaleFactor) {
            Icon icon;
            if (scaleFactor == 1.0f) {
                return this;
            }
            if (!this.isValid()) {
                this.getRealIcon();
            }
            if ((icon = this.myScaledIconsCache.getScaledIcon(scaleFactor)) != null) {
                return icon;
            }
            return this;
        }

        private class MyScaledIconsCache {
            private Map<Boolean, SoftReference<Image>> origImagesCache = Collections.synchronizedMap(new HashMap(2));
            private static final int SCALED_ICONS_CACHE_LIMIT = 5;
            private Map<Float, SoftReference<Icon>> scaledIconsCache = Collections.synchronizedMap(new LinkedHashMap<Float, SoftReference<Icon>>(5){

                @Override
                public boolean removeEldestEntry(Map.Entry<Float, SoftReference<Icon>> entry) {
                    return this.size() > 5;
                }
            });

            private MyScaledIconsCache() {
            }

            public Image getOrigImage(boolean retina) {
                Image img = (Image)SoftReference.dereference(this.origImagesCache.get(retina));
                if (img == null) {
                    img = ImageLoader.loadFromUrl(CachedImageIcon.this.myUrl, UIUtil.isUnderDarcula(), retina, CachedImageIcon.this.filter);
                    this.origImagesCache.put(retina, new SoftReference<Image>(img));
                }
                return img;
            }

            public Icon getScaledIcon(float scale) {
                boolean needRetinaImage;
                Image image;
                float effectiveScale = scale * JBUI.scale(1.0f);
                Icon icon = (Icon)SoftReference.dereference(this.scaledIconsCache.get(Float.valueOf(effectiveScale)));
                if (icon == null && (image = this.getOrigImage(needRetinaImage = effectiveScale >= 1.5f || UIUtil.isRetina())) != null) {
                    Image iconImage = CachedImageIcon.this.getRealIcon().getImage();
                    int width = (int)((float)ImageUtil.getRealWidth(iconImage) * scale);
                    int height = (int)((float)ImageUtil.getRealHeight(iconImage) * scale);
                    Image resizedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
                    if (UIUtil.isRetina()) {
                        resizedImage = RetinaImage.createFrom(resizedImage);
                    }
                    icon = IconLoader.getIcon(resizedImage);
                    this.scaledIconsCache.put(Float.valueOf(effectiveScale), new SoftReference<Icon>(icon));
                }
                return icon;
            }

            public void clear() {
                this.scaledIconsCache.clear();
                this.origImagesCache.clear();
            }
        }
    }
}

