/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Disposer {
    private static final ObjectTree<Disposable> ourTree;
    private static final ObjectTreeAction<Disposable> ourDisposeAction;
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    private Disposer() {
    }

    @NotNull
    public static Disposable newDisposable() {
        return Disposer.newDisposable(null);
    }

    @NotNull
    public static Disposable newDisposable(final @Nullable String debugName) {
        return new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return debugName == null ? super.toString() : debugName;
            }
        };
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child) {
        Disposer.register(parent, child, null);
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child, final @NonNls @Nullable String key) {
        assert (parent != child) : " Cannot register to itself";
        ourTree.register(parent, child);
        if (key != null) {
            assert (Disposer.get(key) == null);
            ourKeyDisposables.put(key, child);
            Disposer.register(child, new Disposable(){

                @Override
                public void dispose() {
                    ourKeyDisposables.remove(key);
                }
            });
        }
    }

    public static boolean isDisposed(@NotNull Disposable disposable) {
        return !ourTree.containsKey(disposable);
    }

    public static Disposable get(@NotNull String key) {
        return ourKeyDisposables.get(key);
    }

    public static void dispose(@NotNull Disposable disposable) {
        Disposer.dispose(disposable, true);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        ourTree.executeAll(disposable, true, ourDisposeAction, processUnregistered);
    }

    public static void disposeChildAndReplace(@NotNull Disposable toDispose, @NotNull Disposable toReplace) {
        ourTree.executeChildAndReplace(toDispose, toReplace, true, ourDisposeAction);
    }

    @NotNull
    public static ObjectTree<Disposable> getTree() {
        return ourTree;
    }

    public static void assertIsEmpty() {
        Disposer.assertIsEmpty(false);
    }

    public static void assertIsEmpty(boolean throwError) {
        if (ourDebugMode) {
            ourTree.assertIsEmpty(throwError);
        }
    }

    public static boolean isEmpty() {
        return ourDebugMode && ourTree.isEmpty();
    }

    public static boolean setDebugMode(boolean debugMode) {
        boolean oldValue = ourDebugMode;
        ourDebugMode = debugMode;
        return oldValue;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    public static void clearOwnFields(@NotNull Object object) {
        Field[] all;
        for (Field each : all = object.getClass().getDeclaredFields()) {
            if ((each.getModifiers() & 0x18) > 0) continue;
            ReflectionUtil.resetField(object, each);
        }
    }

    @Nullable
    public static <T extends Disposable> T findRegisteredObject(@NotNull Disposable parentDisposable, @NotNull T object) {
        return ourTree.findRegisteredObject(parentDisposable, object);
    }

    static {
        try {
            ourTree = new ObjectTree();
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("loader=" + Disposer.class.getClassLoader(), e);
        }
        ourDisposeAction = new ObjectTreeAction<Disposable>(){

            @Override
            public void execute(@NotNull Disposable each) {
                each.dispose();
            }

            @Override
            public void beforeTreeExecution(@NotNull Disposable parent) {
                if (parent instanceof Disposable.Parent) {
                    ((Disposable.Parent)parent).beforeTreeDispose();
                }
            }
        };
        ourKeyDisposables = ContainerUtil.createConcurrentWeakMap();
    }
}

