/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeDisposable
implements Disposable {
    private final List<Disposable> myDisposables = new ArrayList<Disposable>();
    private boolean disposed;

    public void add(@NotNull Disposable disposable) {
        assert (!this.disposed) : "Already disposed";
        this.myDisposables.add(disposable);
    }

    @Override
    public void dispose() {
        for (int i = this.myDisposables.size() - 1; i >= 0; --i) {
            Disposable disposable = this.myDisposables.get(i);
            Disposer.dispose(disposable);
        }
        this.myDisposables.clear();
        this.disposed = true;
    }
}

