/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.google.common.base.Objects;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSystemRunningSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class GradleRunnerConfigurable
extends BaseConfigurable
implements SearchableConfigurable {
    private JPanel myMainPanel;
    private ComboBox myPreferredTestRunner;
    private static final TestRunnerItem[] TEST_RUNNER_ITEMS = new TestRunnerItem[]{new TestRunnerItem(GradleSystemRunningSettings.PreferredTestRunner.PLATFORM_TEST_RUNNER), new TestRunnerItem(GradleSystemRunningSettings.PreferredTestRunner.GRADLE_TEST_RUNNER), new TestRunnerItem(GradleSystemRunningSettings.PreferredTestRunner.CHOOSE_PER_TEST)};
    private final Project myProject;

    public GradleRunnerConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return GradleBundle.message("gradle.runner", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.project.gradle.running";
    }

    public void apply() throws ConfigurationException {
        GradleSystemRunningSettings.getInstance().setPreferredTestRunner(((TestRunnerItem)this.myPreferredTestRunner.getSelectedItem()).value);
    }

    public void reset() {
        GradleSystemRunningSettings settings = GradleSystemRunningSettings.getInstance();
        TestRunnerItem item = GradleRunnerConfigurable.getItem(settings.getPreferredTestRunner());
        this.myPreferredTestRunner.setSelectedItem((Object)item);
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        GradleSystemRunningSettings uiSettings = new GradleSystemRunningSettings();
        TestRunnerItem selectedItem = (TestRunnerItem)this.myPreferredTestRunner.getSelectedItem();
        GradleSystemRunningSettings.PreferredTestRunner preferredTestRunner = selectedItem == null ? GradleSystemRunningSettings.PreferredTestRunner.CHOOSE_PER_TEST : selectedItem.value;
        uiSettings.setPreferredTestRunner(preferredTestRunner);
        GradleSystemRunningSettings settings = GradleSystemRunningSettings.getInstance();
        return !settings.equals(uiSettings);
    }

    public void disposeUIResources() {
    }

    @NotNull
    public String getId() {
        return "reference.settings.project.gradle.running";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    private void createUIComponents() {
        this.myPreferredTestRunner = new ComboBox((Object[])GradleRunnerConfigurable.getItems());
    }

    private static TestRunnerItem getItem(GradleSystemRunningSettings.PreferredTestRunner preferredTestRunner) {
        for (TestRunnerItem item : GradleRunnerConfigurable.getItems()) {
            if (item.value != preferredTestRunner) continue;
            return item;
        }
        return null;
    }

    private static TestRunnerItem[] getItems() {
        return TEST_RUNNER_ITEMS;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ComboBox comboBox = this.myPreferredTestRunner;
        jPanel.add((Component)comboBox, new GridConstraints(1, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 4, 1, 1, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("<html>Run tests using:</html>");
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 5, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    static class TestRunnerItem {
        GradleSystemRunningSettings.PreferredTestRunner value;

        public TestRunnerItem(GradleSystemRunningSettings.PreferredTestRunner value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TestRunnerItem)) {
                return false;
            }
            TestRunnerItem item = (TestRunnerItem)o;
            return this.value == item.value;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value});
        }

        public String toString() {
            return GradleBundle.message("gradle.preferred_test_runner." + (this.value == null ? "CHOOSE_PER_TEST" : this.value.name()), new Object[0]);
        }
    }
}

