/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.externalSystem.service.settings.AbstractExternalSystemConfigurable;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControl;
import org.jetbrains.plugins.gradle.service.settings.GradleSystemSettingsControl;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleConfigurable
extends AbstractExternalSystemConfigurable<GradleProjectSettings, GradleSettingsListener, GradleSettings> {
    @NonNls
    public static final String HELP_TOPIC = "reference.settingsdialog.project.gradle";

    public GradleConfigurable(@NotNull Project project) {
        super(project, GradleConstants.SYSTEM_ID);
    }

    @NotNull
    protected ExternalSystemSettingsControl<GradleProjectSettings> createProjectSettingsControl(@NotNull GradleProjectSettings settings) {
        return new GradleProjectSettingsControl(settings);
    }

    @Nullable
    protected ExternalSystemSettingsControl<GradleSettings> createSystemSettingsControl(@NotNull GradleSettings settings) {
        return new GradleSystemSettingsControl(settings);
    }

    @NotNull
    protected GradleProjectSettings newProjectSettings() {
        return new GradleProjectSettings();
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }

    @NotNull
    public String getHelpTopic() {
        return HELP_TOPIC;
    }
}

