/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemConfigLocator;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleConfigLocator
implements ExternalSystemConfigLocator {
    @NotNull
    public ProjectSystemId getTargetExternalSystemId() {
        return GradleConstants.SYSTEM_ID;
    }

    @Nullable
    public VirtualFile adjust(@NotNull VirtualFile configPath) {
        if (!configPath.isDirectory()) {
            return configPath;
        }
        VirtualFile result = configPath.findChild("build.gradle");
        if (result != null) {
            return result;
        }
        for (VirtualFile child : configPath.getChildren()) {
            String name = child.getName();
            if (!name.endsWith("gradle") || "settings.gradle".equals(name) || child.isDirectory()) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public List<VirtualFile> findAll(@NotNull ExternalProjectSettings externalProjectSettings) {
        ArrayList list = ContainerUtil.newArrayList();
        for (String path : externalProjectSettings.getModules()) {
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path));
            if (vFile == null) continue;
            for (VirtualFile child : vFile.getChildren()) {
                String name = child.getName();
                if (child.isDirectory() || !name.endsWith("gradle")) continue;
                list.add(child);
            }
        }
        return list;
    }
}

