/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public abstract class GradleSimpleContributor
implements GradleMethodContextContributor {
    private final String blockName;
    private final String fqName;
    private final List<String> myMixIns;

    protected GradleSimpleContributor(@NotNull String blockName, @NotNull String fqName, String ... mixIns) {
        this.blockName = blockName;
        this.fqName = fqName;
        this.myMixIns = ContainerUtil.newArrayList((Object[])mixIns);
    }

    @Override
    public void process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (methodCallInfo.isEmpty() || methodCallInfo.size() < 2 || !this.blockName.equals(methodCallInfo.get(1))) {
            return;
        }
        GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        GradleResolverUtil.processDeclarations(psiManager, processor, state, place, this.fqName);
        for (String mixin : this.myMixIns) {
            PsiClass contributorClass = psiManager.findClassWithCache(mixin, place.getResolveScope());
            if (contributorClass == null) continue;
            GradleResolverUtil.processMethod(methodCallInfo.get(0), contributorClass, processor, state, place);
        }
    }
}

