/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import java.io.File;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.config.GradleResourceCompilerConfigurationGenerator;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleProjectImportBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleProjectImportProvider;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class GradleStartupActivity
implements StartupActivity {
    @NonNls
    private static final String SHOW_UNLINKED_GRADLE_POPUP = "show.inlinked.gradle.project.popup";
    private static final String IMPORT_EVENT_DESCRIPTION = "import";
    private static final String DO_NOT_SHOW_EVENT_DESCRIPTION = "do.not.show";

    public void runActivity(@NotNull Project project) {
        GradleStartupActivity.configureBuildClasspath(project);
        GradleStartupActivity.showNotificationForUnlinkedGradleProject(project);
        final GradleResourceCompilerConfigurationGenerator buildConfigurationGenerator = new GradleResourceCompilerConfigurationGenerator(project);
        CompilerManager.getInstance((Project)project).addBeforeTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                AccessToken token = ReadAction.start();
                try {
                    buildConfigurationGenerator.generateBuildConfiguration(context);
                }
                finally {
                    token.finish();
                }
                return true;
            }
        });
    }

    private static void configureBuildClasspath(@NotNull Project project) {
        GradleBuildClasspathManager.getInstance(project).reload();
    }

    private static void showNotificationForUnlinkedGradleProject(final @NotNull Project project) {
        if (!PropertiesComponent.getInstance((Project)project).getBoolean(SHOW_UNLINKED_GRADLE_POPUP, true) || !GradleSettings.getInstance(project).getLinkedProjectsSettings().isEmpty() || project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE || project.getBaseDir() == null) {
            return;
        }
        File baseDir = VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir());
        final File gradleFile = new File(baseDir, "build.gradle");
        if (gradleFile.exists()) {
            String message = String.format("%s<br>\n%s", GradleBundle.message("gradle.notifications.unlinked.project.found.msg", IMPORT_EVENT_DESCRIPTION), GradleBundle.message("gradle.notifications.do.not.show", new Object[0]));
            GradleNotification.getInstance(project).showBalloon(GradleBundle.message("gradle.notifications.unlinked.project.found.title", new Object[0]), message, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    notification.expire();
                    if (GradleStartupActivity.IMPORT_EVENT_DESCRIPTION.equals(e.getDescription())) {
                        ProjectDataManager projectDataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
                        GradleProjectImportBuilder gradleProjectImportBuilder = new GradleProjectImportBuilder(projectDataManager);
                        GradleProjectImportProvider gradleProjectImportProvider = new GradleProjectImportProvider(gradleProjectImportBuilder);
                        AddModuleWizard wizard = new AddModuleWizard(null, gradleFile.getPath(), new ProjectImportProvider[]{gradleProjectImportProvider});
                        if (wizard.getStepCount() <= 0 || wizard.showAndGet()) {
                            ImportModuleAction.createFromWizard((Project)project, (AbstractProjectWizard)wizard);
                        }
                    } else if (GradleStartupActivity.DO_NOT_SHOW_EVENT_DESCRIPTION.equals(e.getDescription())) {
                        PropertiesComponent.getInstance((Project)project).setValue(GradleStartupActivity.SHOW_UNLINKED_GRADLE_POPUP, false, true);
                    }
                }
            });
        }
    }
}

