/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.process.internal.JvmOptions;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.internal.consumer.DefaultExecutorServiceFactory;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.ExecutorServiceFactory;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressEventConverter;
import org.jetbrains.plugins.gradle.service.execution.OutputWrapper;
import org.jetbrains.plugins.gradle.service.project.DistributionFactoryExt;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.tooling.internal.init.Init;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleExecutionHelper {
    private static final Logger LOG = Logger.getInstance(GradleExecutionHelper.class);

    @NotNull
    public <T> ModelBuilder<T> getModelBuilder(@NotNull Class<T> modelType, @NotNull ExternalSystemTaskId id, @Nullable GradleExecutionSettings settings, @NotNull ProjectConnection connection, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull List<String> extraJvmArgs) {
        ModelBuilder result = connection.model(modelType);
        GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings, listener, extraJvmArgs, ContainerUtil.newArrayList(), connection);
        return result;
    }

    @NotNull
    public BuildLauncher getBuildLauncher(@NotNull ExternalSystemTaskId id, @NotNull ProjectConnection connection, @Nullable GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull List<String> vmOptions, @NotNull List<String> commandLineArgs) {
        BuildLauncher result = connection.newBuild();
        GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings, listener, vmOptions, commandLineArgs, connection);
        return result;
    }

    public static void prepare(@NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @Nullable GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull List<String> extraJvmArgs, @NotNull List<String> commandLineArgs, @NotNull ProjectConnection connection) {
        GradleExecutionHelper.prepare(operation, id, settings, listener, extraJvmArgs, commandLineArgs, connection, new OutputWrapper(listener, id, true), new OutputWrapper(listener, id, false));
    }

    public static void prepare(@NotNull LongRunningOperation operation, final @NotNull ExternalSystemTaskId id, @Nullable GradleExecutionSettings settings, final @NotNull ExternalSystemTaskNotificationListener listener, @NotNull List<String> extraJvmArgs, @NotNull List<String> commandLineArgs, @NotNull ProjectConnection connection, @NotNull OutputStream standardOutput, @NotNull OutputStream standardError) {
        Application application;
        if (settings == null) {
            return;
        }
        HashSet jvmArgs = ContainerUtilRt.newHashSet();
        String vmOptions = settings.getDaemonVmOptions();
        if (!StringUtil.isEmpty((String)vmOptions)) {
            CommandLineTokenizer tokenizer = new CommandLineTokenizer(vmOptions);
            while (tokenizer.hasMoreTokens()) {
                String vmOption = tokenizer.nextToken();
                if (StringUtil.isEmpty((String)vmOption)) continue;
                jvmArgs.add(vmOption);
            }
        }
        jvmArgs.addAll(extraJvmArgs);
        if (!jvmArgs.isEmpty()) {
            BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection);
            HashSet merged = buildEnvironment != null ? GradleExecutionHelper.mergeJvmArgs(settings.getServiceDirectory(), buildEnvironment.getJava().getJvmArguments(), jvmArgs) : jvmArgs;
            List filteredArgs = ContainerUtil.mapNotNull((Collection)merged, (Function)new Function<String, String>(){

                public String fun(String s) {
                    return StringUtil.isEmpty((String)s) ? null : s;
                }
            });
            operation.setJvmArguments(ArrayUtil.toStringArray((Collection)filteredArgs));
        }
        if (settings.isOfflineWork()) {
            commandLineArgs.add("--offline");
        }
        if ((application = ApplicationManager.getApplication()) != null && application.isUnitTestMode()) {
            commandLineArgs.add("--info");
            commandLineArgs.add("--recompile-scripts");
        }
        if (!commandLineArgs.isEmpty()) {
            LOG.info("Passing command-line args to Gradle Tooling API: " + commandLineArgs);
            List filteredArgs = ContainerUtil.mapNotNull(commandLineArgs, (Function)new Function<String, String>(){

                public String fun(String s) {
                    return StringUtil.isEmpty((String)s) ? null : s;
                }
            });
            GradleExecutionHelper.replaceTestCommandOptionWithInitScript(filteredArgs);
            operation.withArguments(ArrayUtil.toStringArray((Collection)filteredArgs));
        }
        listener.onStart(id);
        String javaHome = settings.getJavaHome();
        if (javaHome != null && new File(javaHome).isDirectory()) {
            operation.setJavaHome(new File(javaHome));
        }
        operation.addProgressListener(new org.gradle.tooling.ProgressListener(){

            public void statusChanged(org.gradle.tooling.ProgressEvent event) {
                listener.onStatusChange(new ExternalSystemTaskNotificationEvent(id, event.getDescription()));
            }
        });
        operation.addProgressListener(new ProgressListener(){

            public void statusChanged(ProgressEvent event) {
                listener.onStatusChange(GradleProgressEventConverter.convert(id, event));
            }
        });
        operation.setStandardOutput(standardOutput);
        operation.setStandardError(standardError);
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings, @NotNull Function<ProjectConnection, T> f) {
        File projectPathFile = new File(projectPath);
        String projectDir = projectPathFile.isFile() && projectPath.endsWith("gradle") && projectPathFile.getParent() != null ? projectPathFile.getParent() : projectPath;
        String userDir = null;
        if (!GradleEnvironment.ADJUST_USER_DIR) {
            try {
                userDir = System.getProperty("user.dir");
                if (userDir != null) {
                    System.setProperty("user.dir", projectDir);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String graphicsEnv = System.getProperty("java.awt.graphicsenv");
        String awtToolkit = System.getProperty("awt.toolkit");
        ProjectConnection connection = GradleExecutionHelper.getConnection(projectDir, settings);
        try {
            System.clearProperty("java.awt.graphicsenv");
            System.clearProperty("awt.toolkit");
            Object object = f.fun((Object)connection);
            return (T)object;
        }
        catch (ExternalSystemException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.debug("Gradle execution error", e);
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
            throw new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause));
        }
        finally {
            try {
                connection.close();
                if (userDir != null) {
                    System.setProperty("user.dir", userDir);
                }
                if (graphicsEnv != null) {
                    System.setProperty("java.awt.graphicsenv", graphicsEnv);
                }
                if (awtToolkit != null) {
                    System.setProperty("awt.toolkit", awtToolkit);
                }
            }
            catch (Throwable e) {
                LOG.debug("Gradle connection close error", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener) {
        if (!settings.getDistributionType().isWrapped()) {
            return;
        }
        if (settings.getDistributionType() == DistributionType.DEFAULT_WRAPPED && GradleUtil.findDefaultWrapperPropertiesFile(projectPath) != null) {
            return;
        }
        ProjectConnection connection = GradleExecutionHelper.getConnection(projectPath, settings);
        try {
            try {
                File wrapperPropertyFileLocation = FileUtil.createTempFile((String)"wrap", (String)"loc");
                wrapperPropertyFileLocation.deleteOnExit();
                String[] lines = new String[]{"gradle.taskGraph.afterTask { Task task ->", "    if (task instanceof Wrapper) {", "        def wrapperPropertyFileLocation = task.jarFile.getCanonicalPath() - '.jar' + '.properties'", "        new File('" + StringUtil.escapeBackSlashes((String)wrapperPropertyFileLocation.getCanonicalPath()) + "').write wrapperPropertyFileLocation", "}}"};
                File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator()));
                BuildLauncher launcher = this.getBuildLauncher(id, connection, settings, listener, ContainerUtil.newArrayList(), ContainerUtil.newArrayList((Object[])new String[]{"--init-script", tempFile.getAbsolutePath()}));
                launcher.forTasks(new String[]{"wrapper"});
                launcher.run();
                String wrapperPropertyFile = FileUtil.loadFile((File)wrapperPropertyFileLocation);
                settings.setWrapperPropertyFile(wrapperPropertyFile);
            }
            catch (IOException e) {
                LOG.warn("Can't update wrapper", (Throwable)e);
            }
        }
        catch (Throwable e) {
            LOG.warn("Can't update wrapper", e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {}
        }
    }

    private static List<String> mergeJvmArgs(String serviceDirectory, Iterable<String> jvmArgs1, Iterable<String> jvmArgs2) {
        File gradleUserHomeDir = serviceDirectory != null ? new File(serviceDirectory) : new BuildLayoutParameters().getGradleUserHomeDir();
        LOG.debug("Gradle home: " + gradleUserHomeDir);
        NativeServices.initialize((File)gradleUserHomeDir, (boolean)false);
        JvmOptions jvmOptions = new JvmOptions(null);
        jvmOptions.setAllJvmArgs(ContainerUtil.concat((Iterable[])new Iterable[]{jvmArgs1, jvmArgs2}));
        return jvmOptions.getAllJvmArgs();
    }

    @NotNull
    private static ProjectConnection getConnection(@NotNull String projectPath, @Nullable GradleExecutionSettings settings) throws IllegalStateException {
        File projectDir = new File(projectPath);
        GradleConnector connector = GradleConnector.newConnector();
        int ttl = -1;
        if (settings != null) {
            switch (settings.getDistributionType()) {
                case LOCAL: {
                    String gradleHome = settings.getGradleHome();
                    if (gradleHome == null) break;
                    try {
                        connector.useInstallation(new File(gradleHome).getCanonicalFile());
                    }
                    catch (IOException e) {
                        connector.useInstallation(new File(settings.getGradleHome()));
                    }
                    break;
                }
                case WRAPPED: {
                    File propertiesFile;
                    if (settings.getWrapperPropertyFile() == null || !(propertiesFile = new File(settings.getWrapperPropertyFile())).exists()) break;
                    Distribution distribution = new DistributionFactoryExt((ExecutorServiceFactory)new DefaultExecutorServiceFactory()).getWrappedDistribution(propertiesFile);
                    try {
                        GradleExecutionHelper.setField(connector, "distribution", distribution);
                        break;
                    }
                    catch (Exception e) {
                        throw new ExternalSystemException((Throwable)e);
                    }
                }
            }
            String serviceDirectory = settings.getServiceDirectory();
            if (serviceDirectory != null) {
                connector.useGradleUserHomeDir(new File(serviceDirectory));
            }
            if (settings.isVerboseProcessing() && connector instanceof DefaultGradleConnector) {
                ((DefaultGradleConnector)connector).setVerboseLogging(true);
            }
            ttl = (int)settings.getRemoteProcessIdleTtlInMs();
        }
        if (ttl > 0 && connector instanceof DefaultGradleConnector) {
            Application app = ApplicationManager.getApplication();
            ttl = app != null && app.isUnitTestMode() ? 10000 : ttl;
            ((DefaultGradleConnector)connector).daemonMaxIdleTime(ttl, TimeUnit.MILLISECONDS);
        }
        connector.forProjectDirectory(projectDir);
        ProjectConnection connection = connector.connect();
        if (connection == null) {
            throw new IllegalStateException(String.format("Can't create connection to the target project via gradle tooling api. Project path: '%s'", projectPath));
        }
        return connection;
    }

    public static void setField(Object obj, String fieldName, Object fieldValue) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = obj.getClass().getDeclaredField(fieldName);
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        field.set(obj, fieldValue);
        field.setAccessible(isAccessible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static File generateInitScript(boolean isBuildSrcProject, @NotNull Set<Class> toolingExtensionClasses) {
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/init.gradle");
        try {
            if (stream == null) {
                LOG.warn("Can't get init script template");
                File file = null;
                return file;
            }
            String toolingExtensionsJarPaths = GradleExecutionHelper.getToolingExtensionsJarPaths(toolingExtensionClasses);
            String script = FileUtil.loadTextAndClose((InputStream)stream).replaceFirst(Pattern.quote("${EXTENSIONS_JARS_PATH}"), toolingExtensionsJarPaths);
            if (isBuildSrcProject) {
                String buildSrcDefaultInitScript = GradleExecutionHelper.getBuildSrcDefaultInitScript();
                if (buildSrcDefaultInitScript == null) {
                    File file = null;
                    return file;
                }
                script = script + buildSrcDefaultInitScript;
            }
            File file = GradleExecutionHelper.writeToFileGradleInitScript(script);
            return file;
        }
        catch (Exception e) {
            LOG.warn("Can't generate IJ gradle init script", (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    public static File writeToFileGradleInitScript(@NotNull String content) throws IOException {
        return GradleExecutionHelper.writeToFileGradleInitScript(content, "ijinit");
    }

    public static File writeToFileGradleInitScript(@NotNull String content, @NotNull String filePrefix) throws IOException {
        File tempFile = new File(FileUtil.getTempDirectory(), filePrefix + '.' + "gradle");
        if (tempFile.exists() && StringUtil.equals((CharSequence)content, (CharSequence)FileUtil.loadFile((File)tempFile))) {
            return tempFile;
        }
        tempFile = FileUtil.findSequentNonexistentFile((File)tempFile.getParentFile(), (String)filePrefix, (String)"gradle");
        FileUtil.writeToFile((File)tempFile, (String)content);
        tempFile.deleteOnExit();
        return tempFile;
    }

    @Nullable
    public static String getBuildSrcDefaultInitScript() {
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/buildSrcInit.gradle");
        try {
            if (stream == null) {
                String string = null;
                return string;
            }
            String string = FileUtil.loadTextAndClose((InputStream)stream);
            return string;
        }
        catch (Exception e) {
            LOG.warn("Can't use IJ gradle init script", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    @Nullable
    public static GradleVersion getGradleVersion(@NotNull ProjectConnection connection) {
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection);
        GradleVersion gradleVersion = null;
        if (buildEnvironment != null) {
            gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        }
        return gradleVersion;
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection) {
        try {
            BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
            if (LOG.isDebugEnabled()) {
                try {
                    LOG.debug("Gradle version: " + buildEnvironment.getGradle().getGradleVersion());
                    LOG.debug("Gradle java home: " + buildEnvironment.getJava().getJavaHome());
                    LOG.debug("Gradle jvm arguments: " + buildEnvironment.getJava().getJvmArguments());
                }
                catch (Throwable t) {
                    LOG.debug(t);
                }
            }
            return buildEnvironment;
        }
        catch (Exception e) {
            LOG.warn("can not get BuildEnvironment model", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceTestCommandOptionWithInitScript(@NotNull List<String> args) {
        LinkedHashSet testIncludePatterns = ContainerUtil.newLinkedHashSet();
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            String next = it.next();
            if (!"--tests".equals(next)) continue;
            it.remove();
            if (!it.hasNext()) continue;
            testIncludePatterns.add(it.next());
            it.remove();
        }
        if (!testIncludePatterns.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append('[');
            Iterator iterator = testIncludePatterns.iterator();
            while (iterator.hasNext()) {
                String pattern = (String)iterator.next();
                buf.append('\"').append(pattern).append('\"');
                if (!iterator.hasNext()) continue;
                buf.append(',');
            }
            buf.append(']');
            InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/testFilterInit.gradle");
            try {
                if (stream == null) {
                    LOG.warn("Can't get test filter init script template");
                    return;
                }
                String script = FileUtil.loadTextAndClose((InputStream)stream).replaceFirst(Pattern.quote("${TEST_NAME_INCLUDES}"), buf.toString());
                File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(script, "ijtestinit");
                ContainerUtil.addAll(args, (Object[])new String[]{"--init-script", tempFile.getAbsolutePath()});
            }
            catch (Exception e) {
                LOG.warn("Can't generate IJ gradle test filter init script", (Throwable)e);
            }
            finally {
                StreamUtil.closeStream((Closeable)stream);
            }
        }
    }

    @NotNull
    private static String getToolingExtensionsJarPaths(@NotNull Set<Class> toolingExtensionClasses) {
        Set jarPaths = ContainerUtil.map2SetNotNull(toolingExtensionClasses, (Function)new Function<Class, String>(){

            public String fun(Class aClass) {
                String path = PathManager.getJarPathForClass((Class)aClass);
                return path == null ? null : PathUtil.getCanonicalPath((String)path);
            }
        });
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        Iterator it = jarPaths.iterator();
        while (it.hasNext()) {
            String jarPath = (String)it.next();
            buf.append('\"').append(jarPath).append('\"');
            if (!it.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }
}

