/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.frameworkSupport;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BuildScriptDataBuilder {
    @NotNull
    private final VirtualFile myBuildScriptFile;
    private final Set<String> plugins = ContainerUtil.newTreeSet();
    private final Set<String> repositories = ContainerUtil.newTreeSet();
    private final Set<String> dependencies = ContainerUtil.newTreeSet();
    private final Set<String> properties = ContainerUtil.newTreeSet();
    private final Set<String> buildScriptProperties = ContainerUtil.newTreeSet();
    private final Set<String> buildScriptRepositories = ContainerUtil.newTreeSet();
    private final Set<String> buildScriptDependencies = ContainerUtil.newTreeSet();
    private final Set<String> other = ContainerUtil.newTreeSet();

    public BuildScriptDataBuilder(@NotNull VirtualFile buildScriptFile) {
        this.myBuildScriptFile = buildScriptFile;
    }

    @NotNull
    public VirtualFile getBuildScriptFile() {
        return this.myBuildScriptFile;
    }

    public String build() {
        ArrayList lines = ContainerUtil.newArrayList();
        Function<String, String> padding = new Function<String, String>(){

            public String fun(String s) {
                return StringUtil.isNotEmpty((String)s) ? "    " + s : "";
            }
        };
        this.addBuildscriptLines(lines, padding);
        if (!this.plugins.isEmpty()) {
            lines.addAll(this.plugins);
            lines.add("");
        }
        if (!this.properties.isEmpty()) {
            lines.addAll(this.properties);
            lines.add("");
        }
        if (!this.repositories.isEmpty()) {
            lines.add("repositories {");
            lines.addAll(ContainerUtil.map(this.repositories, (Function)padding));
            lines.add("}");
            lines.add("");
        }
        if (!this.dependencies.isEmpty()) {
            lines.add("dependencies {");
            lines.addAll(ContainerUtil.map(this.dependencies, (Function)padding));
            lines.add("}");
            lines.add("");
        }
        if (!this.other.isEmpty()) {
            lines.addAll(this.other);
        }
        return StringUtil.join((Collection)lines, (String)"\n");
    }

    private void addBuildscriptLines(@NotNull List<String> lines, @NotNull Function<String, String> padding) {
        if (!(this.buildScriptRepositories.isEmpty() && this.buildScriptDependencies.isEmpty() && this.buildScriptProperties.isEmpty())) {
            lines.add("buildscript {");
            List buildScriptLines = ContainerUtil.newSmartList();
            if (!this.buildScriptProperties.isEmpty()) {
                buildScriptLines.addAll(this.buildScriptProperties);
                buildScriptLines.add("");
            }
            if (!this.buildScriptRepositories.isEmpty()) {
                buildScriptLines.add("repositories {");
                buildScriptLines.addAll(ContainerUtil.map(this.buildScriptRepositories, padding));
                buildScriptLines.add("}");
            }
            if (!this.buildScriptDependencies.isEmpty()) {
                buildScriptLines.add("dependencies {");
                buildScriptLines.addAll(ContainerUtil.map(this.buildScriptDependencies, padding));
                buildScriptLines.add("}");
            }
            lines.addAll(ContainerUtil.map((Collection)buildScriptLines, padding));
            lines.add("}");
            lines.add("");
        }
    }

    public BuildScriptDataBuilder addBuildscriptPropertyDefinition(@NotNull String definition) {
        this.buildScriptProperties.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addBuildscriptRepositoriesDefinition(@NotNull String definition) {
        this.buildScriptRepositories.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addBuildscriptDependencyNotation(@NotNull String notation) {
        this.buildScriptDependencies.add(notation.trim());
        return this;
    }

    public BuildScriptDataBuilder addPluginDefinition(@NotNull String definition) {
        this.plugins.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addRepositoriesDefinition(@NotNull String definition) {
        this.repositories.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addDependencyNotation(@NotNull String notation) {
        this.dependencies.add(notation.trim());
        return this;
    }

    public BuildScriptDataBuilder addPropertyDefinition(@NotNull String definition) {
        this.properties.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addOther(@NotNull String definition) {
        this.other.add(definition.trim());
        return this;
    }
}

