/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestTasksProvider;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleSystemRunningSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public abstract class GradleTestRunConfigurationProducer
extends RunConfigurationProducer<ExternalSystemRunConfiguration> {
    private static final List<String> TEST_SOURCE_SET_TASKS = ContainerUtil.list((Object[])new String[]{"cleanTest", "test"});

    protected GradleTestRunConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.CHOOSE_PER_TEST || GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.GRADLE_TEST_RUNNER;
    }

    public boolean shouldReplace(ConfigurationFromContext self, ConfigurationFromContext other) {
        return GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.GRADLE_TEST_RUNNER;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(ConfigurationContext context) {
        RunnerAndConfigurationSettings existingConfiguration = super.findExistingConfiguration(context);
        if (existingConfiguration == null && GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.GRADLE_TEST_RUNNER) {
            ConfigurationFromContext createdContext = this.createConfigurationFromContext(context);
            if (createdContext != null) {
                RunnerAndConfigurationSettings settings = createdContext.getConfigurationSettings();
                RunManagerEx manager = RunManagerEx.getInstanceEx((Project)context.getProject());
                manager.setTemporaryConfiguration(settings);
                return settings;
            }
            return null;
        }
        return existingConfiguration;
    }

    protected boolean setupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        if (GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.PLATFORM_TEST_RUNNER) {
            return false;
        }
        return this.doSetupConfigurationFromContext(configuration, context, sourceElement);
    }

    protected abstract boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration var1, ConfigurationContext var2, Ref<PsiElement> var3);

    public boolean isConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        if (GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.PLATFORM_TEST_RUNNER) {
            return false;
        }
        if (configuration == null) {
            return false;
        }
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        return this.doIsConfigurationFromContext(configuration, context);
    }

    protected abstract boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration var1, ConfigurationContext var2);

    @Nullable
    protected String resolveProjectPath(@NotNull Module module) {
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (rootProjectPath == null || projectPath == null) {
            return null;
        }
        if (!FileUtil.isAncestor((String)rootProjectPath, (String)projectPath, (boolean)false)) {
            projectPath = rootProjectPath;
        }
        return projectPath;
    }

    @NotNull
    public static List<String> getTasksToRun(@NotNull Module module) {
        String path;
        List result;
        for (GradleTestTasksProvider provider : (GradleTestTasksProvider[])GradleTestTasksProvider.EP_NAME.getExtensions()) {
            List<String> tasks = provider.getTasks(module);
            if (ContainerUtil.isEmpty(tasks)) continue;
            return tasks;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            return ContainerUtil.emptyList();
        }
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (projectPath == null) {
            return ContainerUtil.emptyList();
        }
        ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)module.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath);
        if (externalProjectInfo == null) {
            return ContainerUtil.emptyList();
        }
        if (StringUtil.endsWith((CharSequence)externalProjectId, (CharSequence)":test") || StringUtil.endsWith((CharSequence)externalProjectId, (CharSequence)":main")) {
            result = TEST_SOURCE_SET_TASKS;
        } else {
            DataNode<ModuleData> moduleNode = GradleProjectResolverUtil.findModule((DataNode<ProjectData>)externalProjectInfo.getExternalProjectStructure(), projectPath);
            if (moduleNode == null) {
                return ContainerUtil.emptyList();
            }
            final String sourceSetId = StringUtil.substringAfter((String)externalProjectId, (String)(((ModuleData)moduleNode.getData()).getExternalName() + ':'));
            if (sourceSetId == null) {
                return ContainerUtil.emptyList();
            }
            DataNode taskNode = ExternalSystemApiUtil.find(moduleNode, (Key)ProjectKeys.TASK, (BooleanFunction)new BooleanFunction<DataNode<TaskData>>(){

                public boolean fun(DataNode<TaskData> node) {
                    return "org.gradle.api.tasks.testing.Test".equals(((TaskData)node.getData()).getType()) && StringUtil.startsWith((CharSequence)sourceSetId, (CharSequence)((TaskData)node.getData()).getName());
                }
            });
            if (taskNode == null) {
                return ContainerUtil.emptyList();
            }
            String taskName = ((TaskData)taskNode.getData()).getName();
            result = ContainerUtil.list((Object[])new String[]{"clean" + StringUtil.capitalize((String)taskName), taskName});
        }
        if (!externalProjectId.startsWith(":")) {
            path = ":";
        } else {
            List pathParts = StringUtil.split((String)externalProjectId, (String)":");
            if (!pathParts.isEmpty()) {
                pathParts.remove(pathParts.size() - 1);
            }
            String join = StringUtil.join((Collection)pathParts, (String)":");
            path = ":" + join + (!join.isEmpty() ? ":" : "");
        }
        return ContainerUtil.map(result, (Function)new Function<String, String>(){

            public String fun(String s) {
                return path + s;
            }
        });
    }
}

